DELIMITER $$
DROP PROCEDURE IF EXISTS V20250509180226__Create_activity_duration_type_CSM $$
CREATE PROCEDURE V20250509180226__Create_activity_duration_type_CSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='activity_duration_type')) THEN 
CREATE TABLE `activity_duration_type` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(50) NOT NULL,
  `itemValue` varchar(100) NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
  KEY `activity_duration_type_lastUpdatedBy_FK` (`lastUpdatedBy`),
  CONSTRAINT `activity_duration_type_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'activity_duration_type')) THEN
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
	INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
	VALUES (@standardMasterMaxId+1, NULL,'activity_duration_type','ACTIVITY_DURATION_TYPE','General Setup','COMMON_MASTER',0,0,NULL,1,now());
    
    SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'activity_duration_type');

	INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
	VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,'50',NULL,1,now());
    
    INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
	VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,'100',NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'ACTIVITY_DURATION_TYPE')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('masterNames', 'ACTIVITY_DURATION_TYPE', 'Activity duration type', 'Activity duration type','Tipe aktiwiteitsduur','Loại thời lượng hoạt động',now(),1);
END IF;

END $$
CALL V20250509180226__Create_activity_duration_type_CSM () $$ 
DROP PROCEDURE IF EXISTS V20250509180226__Create_activity_duration_type_CSM $$ 
DELIMITER ;