DELIMITER $$
DROP PROCEDURE IF EXISTS V20250514123148__Create_ReasonForStudentTransfer $$
CREATE PROCEDURE V20250514123148__Create_ReasonForStudentTransfer()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='reason_for_student_transfer')) THEN 
CREATE TABLE `reason_for_student_transfer` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`studentTransferActive` BIT(1) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `fk_reason_for_student_transfer_lastUpdatedBy_idx` (`lastUpdatedBy`),
	CONSTRAINT `fk_reason_for_student_transfer_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB ;
END IF; 
	-- ------------------CSM DATA-------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'reason_for_student_transfer')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'reason_for_student_transfer','REASON_FOR_STUDENT_TRANSFER','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'reason_for_student_transfer')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'reason_for_student_transfer');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('studentTransferActive','ACTIVE',@standardMasterId,'Boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,1,now());
END IF; 

-- ------------------TRANSLATION-------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'REASON_FOR_STUDENT_TRANSFER')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'REASON_FOR_STUDENT_TRANSFER', 'Reason for Student Transfer', 'Reason for Student Transfer','Rede vir oordrag van studente','Lý do chuyển sinh viên',now(),1);
END IF; 

END $$
CALL V20250514123148__Create_ReasonForStudentTransfer () $$ 
DROP PROCEDURE IF EXISTS V20250514123148__Create_ReasonForStudentTransfer $$ 
DELIMITER ;