DELIMITER $$
DROP PROCEDURE IF EXISTS getBlackbaudTransactionDetails $$
CREATE PROCEDURE getBlackbaudTransactionDetails(IN transactionDate Date)
BEGIN
SELECT 'DEBIT' as type_code,'INVOICE' as transactionType, bh.raiseBillType as  transactionMode,SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1) as account_number,sum(stage.billableAmount) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN prog_batch_seat_config pbsc on bh.programBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE bh.raiseBillCategory = 'BILL_RECEIVABLE'  AND stage.billableAmount > 0 AND bh.billingDate = Date(transactionDate) 
GROUP BY bh.id     
UNION ALL 
SELECT 'CREDIT' as type_code,'INVOICE' as transactionType,bh.raiseBillType as transactionMode,SUBSTRING_INDEX(fh.feeHeadName, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN fee_stage_head_config fshc on stage.feeStageHeadConfigId=fshc.id  
LEFT OUTER JOIN fee_heads fh on fshc.feeHeadId=fh.id
WHERE bh.raiseBillCategory = 'BILL_RECEIVABLE'  AND stage.billableAmount > 0 AND bh.billingDate = Date(transactionDate)  
GROUP BY bh.id,fshc.id

UNION ALL 

SELECT 'DEBIT' as type_code,'CANCELLED INVOICE' as transactionType,bh.raiseBillType as transactionMode,SUBSTRING_INDEX(fh.feeHeadName, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN fee_stage_head_config fshc on stage.feeStageHeadConfigId=fshc.id  
LEFT OUTER JOIN fee_heads fh on fshc.feeHeadId=fh.id
WHERE bh.billStatus = 'CANCELLED' AND bh.raiseBillCategory = 'BILL_RECEIVABLE' AND stage.billableAmount > 0 AND DATE(bh.cancellationDate) = Date(transactionDate)  
GROUP BY bh.id,fshc.id
UNION ALL
SELECT 'CREDIT' as type_code,'CANCELLED INVOICE' as transactionType, bh.raiseBillType as transactionMode, SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN prog_batch_seat_config pbsc on bh.programBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE bh.billStatus = 'CANCELLED'  AND bh.raiseBillCategory = 'BILL_RECEIVABLE'  AND stage.billableAmount > 0 AND DATE(bh.cancellationDate) = Date(transactionDate)  
GROUP BY bh.id  

UNION ALL 

SELECT 'DEBIT' as type_code,'CREDIT NOTE' as transactionType,bh.raiseBillType as transactionMode, SUBSTRING_INDEX(fh.feeHeadName, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN fee_stage_head_config fshc on stage.feeStageHeadConfigId=fshc.id  
LEFT OUTER JOIN fee_heads fh on fshc.feeHeadId=fh.id
WHERE bh.raiseBillCategory = 'BILL_PAYABLE' AND stage.billableAmount > 0 AND bh.billingDate = Date(transactionDate)  
GROUP BY bh.id,fshc.id   
UNION ALL  
SELECT 'CREDIT' as type_code,'CREDIT NOTE' as transactionType, bh.raiseBillType as transactionMode,SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh 
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN prog_batch_seat_config pbsc on bh.programBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE bh.raiseBillCategory = 'BILL_PAYABLE' AND stage.billableAmount > 0 AND bh.billingDate = Date(transactionDate)  
GROUP BY bh.id     

UNION ALL 
    
SELECT 'DEBIT' as type_code,'CANCELLED CREDIT NOTE' as transactionType,bh.raiseBillType as transactionMode,SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN prog_batch_seat_config pbsc on bh.programBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE bh.billStatus = 'CANCELLED'  AND bh.raiseBillCategory = 'BILL_PAYABLE'  AND stage.billableAmount > 0 AND DATE(bh.cancellationDate) = Date(transactionDate)  
GROUP BY bh.id  
UNION ALL 
SELECT 'CREDIT' as type_code,'CANCELLED CREDIT NOTE' as transactionType,bh.raiseBillType as transactionMode,SUBSTRING_INDEX(fh.feeHeadName, '/', 1) as account_number,sum(stage.billableAmount ) AS amount,concat(users.printName,';',bh.billNo) as reference
from bill_header bh  
LEFT OUTER JOIN users users ON bh.studentId = users.id
LEFT OUTER JOIN bill_fee_plan_rule_stage stage on stage.billId = bh.id  
LEFT OUTER JOIN fee_stage_head_config fshc on stage.feeStageHeadConfigId=fshc.id  
LEFT OUTER JOIN fee_heads fh on fshc.feeHeadId=fh.id
WHERE bh.billStatus = 'CANCELLED' AND bh.raiseBillCategory = 'BILL_PAYABLE' AND stage.billableAmount > 0 AND DATE(bh.cancellationDate) = Date(transactionDate)  
GROUP BY bh.id,fshc.id  

UNION ALL
    
SELECT 'DEBIT' as type_code,'RECEIPT' as transactionType,rh.voucherMode as transactionMode,CASE WHEN rh.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(b.bankCode, '/', 1)ELSE NULL END AS account_number,rh.amount AS amount,concat(users.printName,';',rh.receiptNo) as reference
from receipt_header rh  
LEFT OUTER JOIN users users ON rh.studentId = users.id
LEFT OUTER JOIN bank b on rh.depositedBank= b.id
WHERE rh.amount > 0 AND DATE(rh.transactionDate) = Date(transactionDate)  
GROUP BY rh.id
UNION ALL
SELECT 'CREDIT' as type_code,'RECEIPT' as transactionType,rh.voucherMode as transactionMode,CASE WHEN rh.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1)ELSE NULL END AS account_number,rh.amount AS amount,concat(users.printName,';',rh.receiptNo) as reference
from receipt_header rh  
LEFT OUTER JOIN users users ON rh.studentId = users.id
LEFT OUTER JOIN admission ad on users.id = ad.studentId  
LEFT OUTER JOIN program_batch_students pbs on ad.id=pbs.admissionId
LEFT OUTER JOIN prog_batch_seat_config pbsc on pbs.progBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE ad.activeStatus is true and pbs.exitDate is null and pbs.isCurrentPeriod is true and pbs.isCurrentSection is true and pbs.isPeriodCompleted is false AND rh.amount > 0 AND DATE(rh.transactionDate) = Date(transactionDate)  
GROUP BY rh.id
        
        
UNION ALL 

SELECT 'DEBIT' as type_code,'CANCELLED RECEIPT' as transactionType,rh.voucherMode as transactionMode,CASE WHEN rh.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1)ELSE NULL END AS account_number,rh.amount AS amount,concat(users.printName,';',rh.receiptNo) as reference
from receipt_header rh  
LEFT OUTER JOIN users users ON rh.studentId = users.id
LEFT OUTER JOIN admission ad on users.id = ad.studentId  
LEFT OUTER JOIN program_batch_students pbs on ad.id=pbs.admissionId
LEFT OUTER JOIN prog_batch_seat_config pbsc on pbs.progBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE ad.activeStatus is true and pbs.exitDate is null and pbs.isCurrentPeriod is true and pbs.isCurrentSection is true and pbs.isPeriodCompleted is false AND rh.amount > 0 AND rh.status= 'CANCELLED' AND DATE(rh.cancellationDate) = Date(transactionDate)  
GROUP BY rh.id
UNION ALL
SELECT 'CREDIT' as type_code,'CANCELLED RECEIPT' as transactionType,rh.voucherMode as transactionMode,CASE WHEN rh.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(b.bankCode, '/', 1)ELSE NULL END AS account_number,rh.amount AS amount,concat(users.printName,';',rh.receiptNo) as reference
from receipt_header rh  
LEFT OUTER JOIN users users ON rh.studentId = users.id
LEFT OUTER JOIN bank b on rh.depositedBank= b.id
WHERE rh.amount > 0 AND rh.status= 'CANCELLED' AND DATE(rh.cancellationDate) = Date(transactionDate)
GROUP BY rh.id
        
UNION ALL
    
SELECT 'DEBIT' as type_code,'PAYMENT' as transactionType,ph.voucherMode as transactionMode,CASE WHEN ph.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(b.bankCode, '/', 1)ELSE NULL END AS account_number,ph.amount AS amount,concat(users.printName,';',ph.paymentVoucherNo) as reference
from payment_header ph  
LEFT OUTER JOIN users users ON ph.studentId = users.id
LEFT OUTER JOIN bank b on ph.paymentBank= b.id
WHERE ph.amount > 0 AND DATE(ph.transactionDate) = Date(transactionDate)  
GROUP BY ph.id
UNION ALL
SELECT 'CREDIT' as type_code,'PAYMENT' as transactionType,ph.voucherMode as transactionMode,CASE WHEN ph.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1)ELSE NULL END AS account_number,ph.amount AS amount,concat(users.printName,';',ph.paymentVoucherNo) as reference
from payment_header ph 
LEFT OUTER JOIN users users ON ph.studentId = users.id
LEFT OUTER JOIN admission ad on users.id = ad.studentId  
LEFT OUTER JOIN program_batch_students pbs on ad.id=pbs.admissionId
LEFT OUTER JOIN prog_batch_seat_config pbsc on pbs.progBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE ad.activeStatus is true and pbs.exitDate is null and pbs.isCurrentPeriod is true and pbs.isCurrentSection is true and pbs.isPeriodCompleted is false AND ph.amount > 0 AND DATE(ph.transactionDate) = Date(transactionDate)  
GROUP BY ph.id
        
UNION ALL
    
SELECT 'DEBIT' as type_code,'CANCELLED PAYMENT' as transactionType,ph.voucherMode as transactionMode,CASE WHEN ph.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(p.programNameLanguageTwo, '/', 1)ELSE NULL END AS account_number,ph.amount AS amount,concat(users.printName,';',ph.paymentVoucherNo) as reference
from payment_header ph  
LEFT OUTER JOIN users users ON ph.studentId = users.id
LEFT OUTER JOIN admission ad on users.id = ad.studentId  
LEFT OUTER JOIN program_batch_students pbs on ad.id=pbs.admissionId
LEFT OUTER JOIN prog_batch_seat_config pbsc on pbs.progBatchSeatConfigId=pbsc.id
LEFT OUTER JOIN batches b on pbsc.programBatchId=b.id
LEFT OUTER JOIN programs p on b.programId=p.id
WHERE ad.activeStatus is true and pbs.exitDate is null and pbs.isCurrentPeriod is true and pbs.isCurrentSection is true and pbs.isPeriodCompleted is false AND ph.amount > 0 AND ph.status= 'CANCELLED' AND DATE(ph.cancellationDate) = Date(transactionDate)  
GROUP BY ph.id
UNION ALL
SELECT 'CREDIT' as type_code,'CANCELLED PAYMENT' as transactionType,ph.voucherMode as transactionMode,CASE WHEN ph.voucherMode = 'BANK' THEN  SUBSTRING_INDEX(b.bankCode, '/', 1)ELSE NULL END AS account_number, ph.amount AS amount,concat(users.printName,';',ph.paymentVoucherNo) as reference
from payment_header ph  
LEFT OUTER JOIN users users ON ph.studentId = users.id
LEFT OUTER JOIN bank b on ph.paymentBank= b.id
WHERE ph.amount > 0 AND ph.status= 'CANCELLED' AND DATE(ph.cancellationDate) = Date(transactionDate)
GROUP BY ph.id;

END $$
DELIMITER ;