DELIMITER $$
DROP PROCEDURE IF EXISTS V20250522170741__Create_AdmApprovalDetailsTable $$
CREATE PROCEDURE V20250522170741__Create_AdmApprovalDetailsTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='admission_approval_details')) THEN 
CREATE TABLE `admission_approval_details`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`academyLocationId` BIGINT(20) NOT NULL,
	`applicationProgramId` BIGINT(20) NOT NULL,
	`nationalId` varchar(255) NULL DEFAULT NULL,
	`progBatchPeriodConfigId` BIGINT(20) NOT NULL,
	`progBatchSeatConfigId` BIGINT(20) NOT NULL,
	`feePlanRuleId` BIGINT(20) NULL DEFAULT NULL,
	`admissionApprovalDate` DATE NOT NULL,
	`errorMessage` varchar(255) NULL DEFAULT NULL,
	`status` varchar(10) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`),
	CONSTRAINT `adm_approval_details_alId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`),
	CONSTRAINT `adm_approval_details_appProId_FK` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program`(`id`),
	CONSTRAINT `adm_approval_details_periodId_FK` FOREIGN KEY (`progBatchPeriodConfigId`) REFERENCES `prog_batch_period_config`(`id`),
	CONSTRAINT `adm_approval_details_seatTypeId_FK` FOREIGN KEY (`progBatchSeatConfigId`) REFERENCES `prog_batch_seat_config`(`id`),
	CONSTRAINT `adm_approval_details_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)); 
END IF; 

END $$
CALL V20250522170741__Create_AdmApprovalDetailsTable () $$ 
DROP PROCEDURE IF EXISTS V20250522170741__Create_AdmApprovalDetailsTable $$ 
DELIMITER ;