DELIMITER $$
DROP PROCEDURE IF EXISTS V20250526125913__Insert_CourseModuleMapping $$
CREATE PROCEDURE V20250526125913__Insert_CourseModuleMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.tables    WHERE table_schema = DATABASE() AND table_name = 'course_module_mapping')) THEN 
CREATE TABLE `course_module_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT  NOT NULL,
  `hesaSubjectId` BIGINT DEFAULT NULL,
  `weightage` double  DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_course_module_mapping_courseId_idx` (`courseId` ASC),
  INDEX `fk_course_module_mapping_hesaSubjectId_idx` (`hesaSubjectId` ASC),
  INDEX `fk_program_roles_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
 

  CONSTRAINT `fk_course_module_mapping_courseId`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

CONSTRAINT `fk_course_module_mapping_hesaSubjectId`
    FOREIGN KEY (`hesaSubjectId`)
    REFERENCES `hesa_subject` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
    
  CONSTRAINT `fk_course_module_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
    
) ;

END IF;

END $$
CALL V20250526125913__Insert_CourseModuleMapping() $$
DROP PROCEDURE IF EXISTS V20250526125913__Insert_CourseModuleMapping $$
DELIMITER ;