DELIMITER $$
DROP PROCEDURE IF EXISTS V20250616151708__Insert_ExamTransferCredit $$
CREATE PROCEDURE V20250616151708__Insert_ExamTransferCredit()
BEGIN
IF NOT EXISTS (SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'exam_transfer_credit') THEN
CREATE TABLE `exam_transfer_credit` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `courseId` BIGINT NOT NULL,
  `examTransferType` VARCHAR(30),
  `currentMarks` DOUBLE DEFAULT NULL,
  `currentGrade` VARCHAR(30) DEFAULT NULL,
  `equivalentCourseCode` VARCHAR(100) DEFAULT NULL,
  `equivalentCourseName` VARCHAR(100) DEFAULT NULL,
  `institueName` VARCHAR(100) DEFAULT NULL,
  `equivalentCourseCredit` VARCHAR(50) DEFAULT NULL,
  `obtainedMarksGrade` VARCHAR(30),
  `status` VARCHAR(50) DEFAULT 'PENDING',
  `remark` VARCHAR(255),
  `documentId` BIGINT DEFAULT NULL,
  `lastUpdatedBy` BIGINT DEFAULT NULL,
  `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

  PRIMARY KEY (`id`),

  INDEX `fk_exam_transfer_credit_admission_idx` (`admissionId`),
  INDEX `fk_exam_transfer_credit_period_idx` (`periodId`),
  INDEX `fk_exam_transfer_credit_course_idx` (`courseId`),
  INDEX `fk_exam_transfer_credit_document_idx` (`documentId`),
  INDEX `fk_exam_transfer_credit_lastUpdatedBy_idx` (`lastUpdatedBy`),

  CONSTRAINT `fk_exam_transfer_credit_admission`
    FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
     
  CONSTRAINT `fk_exam_transfer_credit_period`
    FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

  CONSTRAINT `fk_exam_transfer_credit_courses`
    FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

  CONSTRAINT `fk_exam_transfer_credit_documents`
    FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`)
    ON DELETE SET NULL ON UPDATE NO ACTION,

  CONSTRAINT `fk_exam_transfer_credit_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
    ON DELETE SET NULL ON UPDATE NO ACTION
);

END IF; 
END $$
CALL V20250616151708__Insert_ExamTransferCredit() $$
DROP PROCEDURE IF EXISTS V20250616151708__Insert_ExamTransferCredit $$
DELIMITER ;