DELIMITER $$
DROP PROCEDURE IF EXISTS fatchHoldUsersInBB $$
CREATE PROCEDURE fatchHoldUsersInBB()
BEGIN

-- Active users with a hold = "NewHold"
select
    bb.id AS blackboardPId, 
    bb.blackboardUserId AS blackboardId,
    bb.academiaUserId AS academiaUserId,
    u.code AS studentCode,
    "NewHold" AS hold 
from blackboard_user_mapping bb
inner join users u on bb.academiaUserId = u.id
left join student_apply_hold_category manageHold on manageHold.studentId = u.id
left join student_finance_hold financeHold on financeHold.studentId= u.id
where 
    bb.isAvailability = b'1'
    and (
        (manageHold.removalDate IS NULL and manageHold.isRemoval = b'0')
        or
        (financeHold.status = 'ACTIVE' and financeHold.unblockedDate IS NULL)
    )
group by u.id

union all

-- Inactive users without a hold = "OldHold"
select 
    bb.id AS blackboardPId, 
    bb.blackboardUserId AS blackboardId,
    bb.academiaUserId AS academiaUserId,
    u.code AS studentCode,
    "OldHold" AS hold 
from blackboard_user_mapping bb
inner join users u on bb.academiaUserId = u.id
where 
    bb.isAvailability = b'0'
    and not exists (
        select 1
        from student_apply_hold_category manageHold
        where manageHold.studentId = u.id
          and manageHold.removalDate IS NULL
          and manageHold.isRemoval = b'0'
    )
    and not exists (
        select 1
        from student_finance_hold financeHold
        where financeHold.studentId = u.id
          and financeHold.status = 'ACTIVE'
          and financeHold.unblockedDate IS NULL
    )
group by u.id;

END $$ 
DELIMITER ;