DELIMITER $$
DROP PROCEDURE IF EXISTS V20250904145357__Create_Buzz_WaterfallAndCapsicum_Report $$
CREATE PROCEDURE V20250904145357__Create_Buzz_WaterfallAndCapsicum_Report()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet');

IF NOT EXISTS(select * from report_template where templateCode = 'BUZZ_WATERFALL_AND_CAPSICUM_PROGRESS_REPORT') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'BUZZ_WATERFALL_AND_CAPSICUM_PROGRESS_REPORT', 'Waterfall & Capsicum Progress Report', 'BUZZ_WATERFALL_AND_CAPSICUM_PROGRESS_REPORT.png', 'CommonReport_BUZZ_WATERFALL_AND_CAPSICUM_PROGRESS_REPORT.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'BUZZ_WATERFALL_AND_CAPSICUM_PROGRESS_REPORT.jasper', 'AcademiaLogo.png');
END IF; 	


set @tempId = (select max(id) from report_template where templateCode='BUZZ_WATERFALL_AND_CAPSICUM_PROGRESS_REPORT');


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REG_NUMBER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_REG_NUMBER', 'Reg Number', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STATEMENT_OF_RESULTS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STATEMENT_OF_RESULTS', 'Statement of Result', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STUDENT_NAME', 'STUDENT NAME', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STUDENT_NO', 'STUDENT NUMBER', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ID/PASSPORT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ID/PASSPORT', 'ID/Passport', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STATEMENT_OF_PERIOD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STATEMENT_OF_PERIOD', 'Statement of Result for the period', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NQF') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NQF', 'NQF Level', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MINIMUM_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MINIMUM_CREDITS', 'Minimum Credits', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SAQA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SAQA', 'SAQA ID', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_INTR_SUMM_ASS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_INTR_SUMM_ASS', 'Internal Summative Assessment', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PRAT_SUMM_ASS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PRAT_SUMM_ASS', 'Practical Summative Assessment', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE_SIG_OFF') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DATE_SIG_OFF', 'Date Signed Off', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MODULE_CODE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MODULE_CODE', 'Module Code', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MODULE_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MODULE_NAME', 'Name of Module', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CREDITS', 'Credits', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ACHIEVEMENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ACHIEVEMENT', 'Achievement', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUMMARY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUMMARY', '*Achievements may either be indicated by means of “Pass/Fail” or “C/NYC”', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUMMARY1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUMMARY1', 'Note: A learner gains entrance to the External Integrated Summative Assessment (EISA)/(FISA) conducted by the AQP if ALL Knowledge, Practical and Work Experience Modules have been successfully completed.', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUMMARY2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUMMARY2', 'Learner has gained admission to the EISA', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUMMARY3') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUMMARY3', 'Date of Next EISA', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUMMARY4') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUMMARY4', 'Learners must bring this SOR together with their ID’s when writing the EISA', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE_ISSUED') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DATE_ISSUED', 'Date Issued', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CAMPUS_HEAD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CAMPUS_HEAD', 'Campus Head', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUMMARY5') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUMMARY5', 'This statement of Results is not an Occupational Certificate. The learner must comply with the requirements of the Knowledge, Practical and Workplace Components of the qualification in order to be admitted to the EISA. This SoR is valid for a period of two years from date of issue. The Quality Council for Trade and Occupations (QCTO) will issue the Occupational Certificate upon successful completion of the External Integrated Summative Assessment, and having met the requirements of the qualification.', '1', now());
END IF;


END $$
CALL V20250904145357__Create_Buzz_WaterfallAndCapsicum_Report () $$ 
DROP PROCEDURE IF EXISTS V20250904145357__Create_Buzz_WaterfallAndCapsicum_Report $$ 
DELIMITER ;