DELIMITER $$

DROP PROCEDURE IF EXISTS V20250905080759__Alter_AlterUserSocial $$

CREATE PROCEDURE V20250905080759__Alter_AlterUserSocial()
BEGIN
    -- Add new columns if they don't already exist
    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_NAME = 'users_social'
          AND TABLE_SCHEMA = DATABASE()
          AND COLUMN_NAME = 'isSsoInactivated'
    ) THEN
        ALTER TABLE users_social
        ADD COLUMN isSsoInactivated TINYINT(1) DEFAULT 0;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_NAME = 'users_social'
          AND TABLE_SCHEMA = DATABASE()
          AND COLUMN_NAME = 'inactivationError'
    ) THEN
        ALTER TABLE users_social
        ADD COLUMN inactivationError VARCHAR(4096) DEFAULT NULL;
    END IF;
END $$

CALL V20250905080759__Alter_AlterUserSocial() $$

DROP PROCEDURE IF EXISTS V20250905080759__Alter_AlterUserSocial $$

DELIMITER ;