
DELIMITER $$
DROP PROCEDURE IF EXISTS V20250909120644__Create_stdCourseEnrollmentChanges $$
CREATE PROCEDURE V20250909120644__Create_stdCourseEnrollmentChanges()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_course_enrollment_changes')) THEN
CREATE TABLE student_course_enrollment_changes (
    `id` BIGINT AUTO_INCREMENT PRIMARY KEY,
    `admissionId` BIGINT NOT NULL,
    `changeDate`  TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `status` VARCHAR(50) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
     `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	INDEX `fk_course_enrollment_changes_admission_idx` (`admissionId` ASC),
	INDEX `fk_course_enrollment_changes_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_course_enrollment_changes_admission_id`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    
	CONSTRAINT `fk_course_enrollment_changes_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF;
END $$
CALL V20250909120644__Create_stdCourseEnrollmentChanges () $$ 
DROP PROCEDURE IF EXISTS V20250909120644__Create_stdCourseEnrollmentChanges $$ 
DELIMITER ;