DELIMITER $$
DROP PROCEDURE IF EXISTS V20250929112153__Create_CcAvenue_Payment_Child $$
CREATE PROCEDURE V20250929112153__Create_CcAvenue_Payment_Child()
BEGIN
SET SQL_SAFE_UPDATES = 0;
    IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'ccavenue_payment_gateway') THEN
        CREATE TABLE `ccavenue_payment_gateway` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `academyLocationId` BIGINT(20) NOT NULL,
			`merchantId` VARCHAR(1000),
			`paymentURL` VARCHAR(1000),
            `orderStatusURL` VARCHAR(1000),
			`accessCode` VARCHAR(1000),
            `workingKey` VARCHAR(1000),
            `currencyCode` VARCHAR(1000),
            `language` VARCHAR(1000),
            `customField1` VARCHAR(1000),
            `customField2` VARCHAR(1000),
           `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `lastUpdatedBy` BIGINT(20) NOT NULL,
            PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
            INDEX `fk_ccavenue_payment_gateway_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_ccavenue_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_ccavenue_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
        );
    END IF;
    IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'ccavenue_payment_gateway' LIMIT 1) THEN
        SET @standardMasterMaxId = (SELECT COALESCE(MAX(id)) FROM standard_master);
        INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
        VALUES (@standardMasterMaxId + 1, 'ccavenue_payment_gateway', 'CCAvenue', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
    END IF;
    SET @standardMasterId = (SELECT id FROM standard_master WHERE `tableName` = 'ccavenue_payment_gateway' order by  id desc limit 1);
    IF @standardMasterId IS NOT NULL THEN
        UPDATE `standard_master` SET `childMaster` = @standardMasterId, `whetherParent` = 1 WHERE `tableName` = 'standard_payment_gateway';
        IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'CCAvenue') THEN
            INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)
            VALUES (@standardMasterId, 'CCAvenue', false, NOW(), 1);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'paymentURL' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('paymentURL', 'PAYMENT_URL', @standardMasterId, 'Varchar', 2, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'orderStatusURL' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('orderStatusURL', 'ORDER_STATUS_URL', @standardMasterId, 'Varchar', 3, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'accessCode' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('accessCode', 'ACCESS_CODE', @standardMasterId, 'Varchar', 4, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'workingKey' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('workingKey', 'WORKING_KEY', @standardMasterId, 'Varchar', 5, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'merchantId' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('merchantId', 'MERCHANT_ID', @standardMasterId, 'Varchar', 6, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('currencyCode', 'CURRENCY_CODE', @standardMasterId, 'Varchar', 7, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'language' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('language', 'LANGUAGE', @standardMasterId, 'Varchar', 8, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customField1' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('customField1', 'CUSTOM_FIELD_1', @standardMasterId, 'Varchar', 9, 0, 0 ,0 , 1, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customField2' AND standardMasterId = @standardMasterId) THEN
			INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
		    VALUES ('customField2', 'CUSTOM_FIELD_2', @standardMasterId, 'Varchar', 10, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
    END IF;
    
    IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'PAYMENT_URL' and  objectName ='TRANSLATIONS')) THEN 
     INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
     VALUES ('TRANSLATIONS','PAYMENT_URL',"Payment Url","Payment Url","Betalings-URL","Url thanh toán",now(),1);
    END IF; 
    
    IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'ORDER_STATUS_URL' and  objectName ='TRANSLATIONS')) THEN 
     INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
      VALUES ('TRANSLATIONS','ORDER_STATUS_URL',"Order Status Url","Order Status Url","Bestelstatus-URL","Url trạng thái đơn hàng",now(),1);
    END IF; 

  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'ACCESS_CODE' and  objectName ='TRANSLATIONS')) THEN 
   INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
   VALUES ('TRANSLATIONS','ACCESS_CODE',"Access Code","Access Code","Toegangskode","Mã truy cập",now(),1);
  END IF; 

  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'WORKING_KEY' and  objectName ='TRANSLATIONS')) THEN 
   INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
   VALUES ('TRANSLATIONS','WORKING_KEY',"Working Key","Working Key","Werkende sleutel","Phím làm việc",now(),1);
  END IF; 

    SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20250929112153__Create_CcAvenue_Payment_Child () $$
DROP PROCEDURE IF EXISTS V20250929112153__Create_CcAvenue_Payment_Child $$
DELIMITER ;