DELIMITER $$

DROP EVENT IF EXISTS cleanup_quick_poll_data $$
CREATE EVENT cleanup_quick_poll_data
ON SCHEDULE EVERY 4 HOUR
DO
BEGIN
    DELETE t1
    FROM user_survey_submission_details AS t1
    JOIN general_survey_csm AS t2 
        ON t1.surveyToken = t2.surveyToken
    WHERE t2.numberOfDays > 0 
      AND t2.publishDate < ( NOW() - INTERVAL t2.numberOfDays DAY);

    UPDATE general_survey_csm 
    SET publishDate = NOW()
    WHERE numberOfDays > 0 
      AND publishDate < ( NOW() - INTERVAL numberOfDays DAY);
END $$

DELIMITER ;