DELIMITER $$
DROP PROCEDURE IF EXISTS V20251008124753__Insert_programCompAwardGrpFin $$
CREATE PROCEDURE V20251008124753__Insert_programCompAwardGrpFin()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_completion_award_finance_mapping')) THEN 
CREATE TABLE `program_completion_award_finance_mapping` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `ProgramCompletionAwardTypeId` BIGINT(20) NOT NULL,
  `programGroupFinanceId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `FK_program_completion_award_idx` (`ProgramCompletionAwardTypeId` ASC) ,
  INDEX `FK_progrma_group_finance_idx` (`programGroupFinanceId` ASC) ,
  INDEX `FK_award_finance_lastUpdatedBy_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `FK_program_completion_award`
    FOREIGN KEY (`ProgramCompletionAwardTypeId`)
    REFERENCES `program_completion_award_type_csm` (`id`),
  CONSTRAINT `FK_progrma_group_finance`
    FOREIGN KEY (`programGroupFinanceId`)
    REFERENCES `program_group_finance` (`id`),
  CONSTRAINT `FK_award_finance_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20251008124753__Insert_programCompAwardGrpFin() $$
DROP PROCEDURE IF EXISTS V20251008124753__Insert_programCompAwardGrpFin $$
DELIMITER ;