DELIMITER $$
DROP PROCEDURE IF EXISTS V20251014183649__Update_Student_Al_Transfer_Conf_Sql $$
CREATE PROCEDURE V20251014183649__Update_Student_Al_Transfer_Conf_Sql()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName` = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_DL');
    IF EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId` = @dtproviderId) THEN
        UPDATE `sql_dtprovider`
        SET `sqlQuery` = 'SELECT
                              T1.id AS USER_ID
                          FROM
                              users T1
                          LEFT JOIN students T4 ON T4.userId = T1.id
                          WHERE
                              T1.id IN (namedParams)',
            `jsonString` = NULL
        WHERE `dataProviderId` = @dtproviderId;
    END IF;

    -- Second dtprovider update
    IF EXISTS (SELECT MAX(id) FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT') THEN
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        IF EXISTS (SELECT id FROM sql_dtprovider WHERE dataProviderId = @dtproviderId) THEN
            UPDATE sql_dtprovider
            SET sqlQuery = 'SELECT
                    T1.userId AS ID,
                    T9.`displayName` AS ACADEMY_NAME,
                    fpd.`feePayerPrintName` AS FEE_PAYER_NAME,
                    fpd.`firstName` AS FIRST_NAME,
                    fpd.`middleName` AS MIDDLE_NAME,
                    fpd.`lastName` AS LAST_NAME,
                    fpd.`mobileNumber` AS MOBILE_NO,
                    fpd.`emailHome` AS EMAIL_ID,
                    T3.`printName` AS STUDENT_PRINT_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN fee_payer_detail fpd ON fpd.personId = T3.id
                WHERE
                    T8.id IN (namedParams)
                    AND fpd.isPrimaryFeePayer = true
                    AND STRD.fromALId IS NOT NULL'
            WHERE dataProviderId = @dtproviderId;
        END IF;
    END IF;

    -- Third dtprovider update
    SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName` = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_DL');
    IF EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId` = @dtproviderId) THEN
        UPDATE `sql_dtprovider`
        SET `sqlQuery` = 'SELECT
                              T3.id AS USER_ID
                          FROM
                              users T1
                          LEFT JOIN students s ON T1.id = s.userId
                          LEFT JOIN person_relationships T2 ON T2.personId = s.personId
                          LEFT JOIN persons T3 ON T3.id = T2.relatedPersonId
                          WHERE
                              T1.id IN (namedParams)
                              AND T2.relationship = "MOTHER"',
            `jsonString` = NULL
        WHERE `dataProviderId` = @dtproviderId;
    END IF;

    -- Fourth dtprovider update
    IF EXISTS (SELECT MAX(id) FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT') THEN
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        IF EXISTS (SELECT id FROM sql_dtprovider WHERE dataProviderId = @dtproviderId) THEN
            UPDATE sql_dtprovider
            SET sqlQuery = 'SELECT
                    T7.id AS ID,
                    T9.`displayName` AS ACADEMY_NAME,
                    T7.`printName` AS MOTHER_NAME,
                    T7.`firstName` AS FIRST_NAME,
                    T7.`middleName` AS MIDDLE_NAME,
                    T7.`lastName` AS LAST_NAME,
                    T7.`emailId` AS EMAIL_ID,
                    T7.`mobileNumber` AS MOBILE_NO,
                    T3.`printName` AS STUDENT_PRINT_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN person_relationships T5 ON T3.id = T5.personId
                    LEFT JOIN persons T7 ON T5.relatedPersonId = T7.id
                WHERE
                    T7.id IN (namedParams)
                    AND T5.relationship = "MOTHER"
                    AND T5.whetherDeleted = FALSE
                GROUP BY T1.userId'
            WHERE dataProviderId = @dtproviderId;
        END IF;
    END IF;

    SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20251014183649__Update_Student_Al_Transfer_Conf_Sql () $$
DROP PROCEDURE IF EXISTS V20251014183649__Update_Student_Al_Transfer_Conf_Sql $$
DELIMITER ;