DELIMITER $$
DROP PROCEDURE IF EXISTS V20251016142544__Insert_AppFeeHeadDetailsDataProvider $$
CREATE PROCEDURE V20251016142544__Insert_AppFeeHeadDetailsDataProvider()
BEGIN

IF EXISTS ((SELECT id FROM  dydt_data_provider where providerName = 'OFFER_LETTER_INFO')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM dydt_data_line_item);
SET @dydtdataproviderId = (SELECT id FROM  dydt_data_provider where providerName = 'OFFER_LETTER_INFO');
SET @executionOrder = (SELECT MAX(executionOrder) FROM dydt_data_line_item WHERE dataProviderId=@dydtdataproviderId);
IF NOT EXISTS (SELECT dataProviderId FROM dydt_data_line_item where dataSourceCode='APPLICATION_FEE_HEAD_DETAILS_INFO' AND dataProviderId=@dydtdataproviderId) THEN
INSERT INTO dydt_data_line_item (id, dataProviderId, dataSourceCode, executionOrder, publishAsParametersDef, whetherDataSource, whetherPrimaryDataSource, sqlSelectQueryDef
, whereClauseBindingDef, resultColumnsDef, sqlWhereQueryDef, whetherMultiRecord)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'APPLICATION_FEE_HEAD_DETAILS_INFO', @executionOrder+1 , null, '1', '0', 
            'SELECT
		fh.feeHeadName AS fee_head,
        fshd.feeAmount AS fps_total,
        COALESCE(aoi.financialAidGranted, 0) AS financial_aid,
        prog.programCode as programCode,
        prog.programName as programName,
        py.itemValue  as periodYear,
        pbpc.printName as periodName,
        pbpc.id as periodId,
        pbpc.programPeriodSeq as sequence,
        fp.feePlanName as FeePlanName
    FROM fee_stage_head_config fshd
     JOIN fee_plan_rule_stage fprs ON fshd.feePlanRuleStageId = fprs.id
     JOIN fee_stage_master fsm ON fsm.id = fprs.stageId and fsm.stageName = "Course execution"
     JOIN fee_heads fh ON fshd.feeHeadId = fh.id AND fh.whetherDiscountFeeHead = 0
     JOIN fee_plan_rules fpr ON fprs.feePlanRuleId = fpr.id
     JOIN fee_plan fp ON fpr.feePlanId = fp.id AND fp.feePlanStatus = "ACTIVE"
     JOIN fee_plan_type fpt ON fpt.id = fp.feePlanType AND fpt.feePlanType = "Program"
     JOIN fee_plan_acad_locations apal ON fp.id = apal.feePlanId
	JOIN prog_batch_period_config pbpc on pbpc.id = apal.progBatchPeriodConfigId
    JOIN batches b ON pbpc.programBatchId = b.id
    JOIN programs prog on b.programId = prog.id
    LEFT JOIN period_year py on py.id = pbpc.periodYearId
    LEFT JOIN program_batch_students pbs ON pbs.programBatchId = b.id
    LEFT JOIN fee_plan_submission_sch fps ON fps.feeStageHeadConfigId = fshd.id
     JOIN application_program ap ON ap.programId = prog.id
     JOIN application aa ON aa.id = ap.applicationId
    LEFT JOIN applicant_person app ON app.id = aa.applicantPersonId
    LEFT JOIN applicant_other_information aoi ON aoi.applicantPersonId = app.id
    LEFT JOIN applicant_other_information_cd aoic ON aoic.applicantOtherInfoId = aoi.id','PRM_APPLICATION_PROGRAM_ID','APPLICATION_FEE_HEAD_DETAILS_INFO',
            'WHERE ap.id = PRM_APPLICATION_PROGRAM_ID  GROUP BY fh.feeHeadName, pbpc.id, prog.programCode  order by pbpc.programPeriodSeq','1');
END IF;
END IF;

SET @dataLineItemId = (SELECT id FROM dydt_data_line_item WHERE dataSourceCode = 'APPLICATION_FEE_HEAD_DETAILS_INFO');
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APPLICATION_FEE_HEAD_DETAILS_INFO') THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId)
VALUES ('APPLICATION_FEE_HEAD_DETAILS_INFO', 'Applicatoin Fee Head Details Info', @dataLineItemId);
END IF; 

END $$
CALL V20251016142544__Insert_AppFeeHeadDetailsDataProvider() $$
DROP PROCEDURE IF EXISTS V20251016142544__Insert_AppFeeHeadDetailsDataProvider $$
DELIMITER ;