DELIMITER $$

DROP PROCEDURE IF EXISTS V20251027130149__Alter_progBatchPeriodConfigAddHomeRoom $$

CREATE PROCEDURE V20251027130149__Alter_progBatchPeriodConfigAddHomeRoom()
BEGIN

  -- Check if 'roomId' column already exists
  IF NOT EXISTS (
    SELECT *
    FROM information_schema.COLUMNS
    WHERE table_schema = DATABASE()
      AND table_name = 'prog_batch_period_config'
      AND column_name = 'roomId'
  ) THEN
  
    -- Add column and foreign key
    ALTER TABLE `prog_batch_period_config`
      ADD COLUMN `roomId` BIGINT NULL,
      ADD CONSTRAINT `fk_room_Id` FOREIGN KEY (`roomId`) REFERENCES `resources`(`id`);
  
  END IF;

END $$

CALL V20251027130149__Alter_progBatchPeriodConfigAddHomeRoom() $$

DROP PROCEDURE IF EXISTS V20251027130149__Alter_progBatchPeriodConfigAddHomeRoom $$

DELIMITER ;
