DELIMITER $$
DROP PROCEDURE IF EXISTS V20251029104406__Create_whatsapp_setup_configuration $$
CREATE PROCEDURE V20251029104406__Create_whatsapp_setup_configuration()
BEGIN

IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='whatsapp_setup_configuration') THEN 
	CREATE TABLE whatsapp_setup_configuration
	( id bigint NOT NULL AUTO_INCREMENT,
	itemCode varchar(255) NOT NULL,
	sourceName varchar(100) DEFAULT NULL,
	academyLocationId bigint NOT NULL,
	whatsAppNumber varchar(15) NOT NULL,
	wabaId  varchar(100) DEFAULT NULL,
	apiURI  varchar(100) DEFAULT NULL,
	apiKey  varchar(100) DEFAULT NULL,
	academiaERPUrl  varchar(100) DEFAULT NULL,
	customField1 varchar(50) DEFAULT NULL,
	customField2 varchar(50) DEFAULT NULL,
	isDefault bit(1) DEFAULT NULL,
	isActive bit(1) DEFAULT NULL,
	lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	lastUpdatedBy bigint DEFAULT NULL,
	PRIMARY KEY (id),
	KEY whatsapp_configuration_lastUpdatedBy_FK (lastUpdatedBy),
	KEY whatsapp_configuration_academyLocationId_FK (academyLocationId),
	CONSTRAINT whatsapp_configuration_academyLocationId_FK FOREIGN KEY (academyLocationId) REFERENCES academy_location (id),
	CONSTRAINT whatsapp_configuration_lastUpdatedBy_FK FOREIGN KEY (lastUpdatedBy) REFERENCES users (id));
END IF; 

END $$
CALL V20251029104406__Create_whatsapp_setup_configuration () $$ 
DROP PROCEDURE IF EXISTS V20251029104406__Create_whatsapp_setup_configuration $$ 
DELIMITER ;