DELIMITER $$
DROP PROCEDURE IF EXISTS V20251029104623__Add_whatsapp_setp_config_item $$
CREATE PROCEDURE V20251029104623__Add_whatsapp_setp_config_item()
BEGIN

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

	IF NOT EXISTS ((SELECT 1 FROM standard_master WHERE masterName = 'WHATSAPP_SETUP_CONFIGURATION')) THEN 
	INSERT INTO standard_master(id,childMaster,tableName,masterName,moduleName,filterCode,whetherChild,whetherParent, droolsAgenda,lastUpdatedBy,lastUpdate) 
	VALUES (@standardMasterMaxId+1, NULL,'whatsapp_setup_configuration','WHATSAPP_SETUP_CONFIGURATION','OTHER','MASTER_WITH_AL',
	0,0,NULL,1,@currentTimeStamp);
	END IF; 

	IF  EXISTS ((SELECT 1 FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
	SET @standardMasterId=(select id from standard_master where tableName = 'whatsapp_setup_configuration');

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('itemCode','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,
	0,NULL,NULL,NULL,0,0,0,
	NULL,NULL,NULL,1,now());
	
	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('sourceName','SOURCE_NAME',399,'Varchar',NULL,1,
	0,NULL,NULL,NULL,0,0,0,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('academyLocation','ACADEMY_LOCATION',@standardMasterId,'Varchar',NULL,2,
	1,'academy_location','id','academyLocationName',0,0,0,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('whatsAppNumber','WHATSAPP_NUMBER',@standardMasterId,'Varchar',NULL,3,
	0,NULL,NULL,NULL,0,0,0,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('wabaId','WABA_ID',@standardMasterId,'Varchar',NULL,4,
	0,NULL,NULL,NULL,0,0,1,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('apiURI','API_URI',@standardMasterId,'Varchar',NULL,5,
	0,NULL,NULL,NULL,0,0,0,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('apiKey','API_KEY',@standardMasterId,'Varchar',NULL,6,
	0,NULL,NULL,NULL,0,0,0,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('academiaERPUrl','ACADEMIA_ERP_URL',@standardMasterId,'Varchar',NULL,7,
	0,NULL,NULL,NULL,0,0,0,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('customField1','CUSTOM_FIELD_1',@standardMasterId,'Varchar',NULL,8,
	0,NULL,NULL,NULL,0,0,1,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('customField2','CUSTOM_FIELD_2',@standardMasterId,'Varchar',NULL,9,
	0,NULL,NULL,NULL,0,0,1,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('isDefault','IS_DEFAULT',@standardMasterId,'Boolean',NULL,10,
	0,NULL,NULL,NULL,0,0,1,
	NULL,NULL,NULL,1,now());

	INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
	whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
	validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
	VALUES ('isActive','IS_ACTIVE',@standardMasterId,'Boolean',NULL,11,
	0,NULL,NULL,NULL,0,0,1,
	NULL,NULL,NULL,1,now());

	END IF; 

	-- translations

	IF NOT EXISTS ((SELECT 1 FROM ui_translation WHERE objectName = 'masterNames' and keyName = 'WHATSAPP_SETUP_CONFIGURATION')) THEN 
	INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	VALUES ('masterNames', 'WHATSAPP_SETUP_CONFIGURATION', 'Whatsapp Setup Configuration', 'Whatsapp Setup Configuration',
	'Whatsapp-opstellingkonfigurasie','Cấu hình thiết lập Whatsapp',now(),1);
	END IF;

	IF NOT EXISTS ((SELECT 1 FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'WHATSAPP_NUMBER')) THEN 
	INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	VALUES ('TRANSLATIONS', 'WHATSAPP_NUMBER', 'Whatsapp Number', 'Whatsapp Number',
	null,null,now(),1);
	END IF;

	IF NOT EXISTS ((SELECT 1 FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'WABA_ID')) THEN 
	INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	VALUES ('TRANSLATIONS', 'WABA_ID', 'Waba Id', 'Waba Id',
	null,null,now(),1);
	END IF;

	IF NOT EXISTS ((SELECT 1 FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'API_URI')) THEN 
	INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	VALUES ('TRANSLATIONS', 'API_URI', 'Api Uri', 'Api Uri',
	null,null,now(),1);
	END IF;

	IF NOT EXISTS ((SELECT 1 FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'API_KEY')) THEN 
	INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	VALUES ('TRANSLATIONS', 'API_KEY', 'Api Key', 'Api Key',
	null,null,now(),1);
	END IF;

	IF NOT EXISTS ((SELECT 1 FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'ACADEMIA_ERP_URL')) THEN 
	INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	VALUES ('TRANSLATIONS', 'ACADEMIA_ERP_URL', 'Academia Erp Url', 'Academia Erp Url',
	NUll,null,now(),1);
	END IF;

END $$
CALL V20251029104623__Add_whatsapp_setp_config_item () $$ 
DROP PROCEDURE IF EXISTS V20251029104623__Add_whatsapp_setp_config_item $$ 
DELIMITER ;