DELIMITER $$
DROP PROCEDURE IF EXISTS V20251118144329__Update_UpdateOfferLetterTCreditData $$
CREATE PROCEDURE V20251118144329__Update_UpdateOfferLetterTCreditData()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_ID')) THEN 
SET @dydtDataLineItemId=(select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_ID');
update dydt_data_line_item set sqlSelectQueryDef="SELECT ap.firstName AS applicant_firstname, 
ap.lastName AS applicant_lastname, 
ap.middleName AS applicant_middlename,
 g.itemValue AS applicant_gender, 
 ap.printName AS applicant_printname, 
 a.code AS application_code, 
 s.salutationName AS applicant_salutation,
 ap.birthDate AS birth_date, 
 ap.photoUrl AS app_photo_url,
 ahr.whetherHostelApplicable AS Hostel_Applicable, 
 ml.itemValue AS correspondance_language,
 ca.itemValue AS current_activity, 
 s.salutationNameInOtherLanguage AS applicant_salutation_otr_lang,
 ap.nationalID AS ap_nationalID,
 ap.emailId AS ap_primary_email_id, 
 applicant_other_information_cd.cf1 AS customfield_1, 
 applicant_other_information_cd.cf2 AS customfield_2, 
 applicant_other_information_cd.cf3 AS customfield_3,
 applicant_other_information_cd.cf4 AS customfield_4, 
 applicant_other_information_cd.cf5 AS customfield_5, 
 applicant_other_information_cd.cf6 AS customfield_6, 
 applicant_other_information_cd.cf7 AS customfield_7, 
 aprel_father.mobileCountryCode AS father_mobileCountryCode, 
 aprel_father.mobileNumber AS father_mobileNumber, 
 aprel_father.emailId AS father_emailId, 
 aprel_guardian.mobileCountryCode AS guardian_mobileCountryCode, 
 aprel_guardian.mobileNumber AS guardian_mobileNumber, 
 aprel_guardian.emailId AS guardian_emailId, 
 ap.initials AS student_id, 
 ap.birth_place AS birth_place, 
 ap.birth_place_language AS birth_place_language, 
 nationalities.itemValue AS nationalitie,
 ap.entryRoute AS entry_route,
 ap.englishProficiency AS english_proficiency,
 ap.motivation AS motivation,
 ecs.itemValue as ProgramMajor,
 cc.itemValue as  AdmissionAcademicTerm,
 atcc.programDuration as Program_Duration,
 atcc.expectedCompletionDate as Expected_Completion_Date,
 atcc.exemptedCredit as Exempted_Credit,
 ap.personalIncome as personalIncome,
ap.category as category,
ap.postNumber as postNumber,
 GROUP_CONCAT(DISTINCT c_repeat.courseCode ORDER BY c.courseCode SEPARATOR ', ') AS Repeat_Course_Code,
 GROUP_CONCAT(DISTINCT c.courseCode ORDER BY c.courseCode SEPARATOR ', ') AS Course_Code
 FROM application a 
 LEFT JOIN applicant_person ap ON a.applicantPersonId = ap.id 
 LEFT JOIN applicant_hostel_requirement ahr ON ahr.applicantPersonId = ap.id 
 LEFT JOIN salutations s ON ap.salutationId = s.id 
 LEFT JOIN current_activity ca ON ca.id = ap.current_activity_id 
 LEFT JOIN gender g ON g.id = ap.genderId 
 LEFT JOIN multi_language ml ON ml.id = ap.correspondence_language 
 LEFT JOIN applicant_other_information ON applicant_other_information.applicantPersonId = ap.id 
 LEFT JOIN applicant_other_information_cd ON applicant_other_information.id = applicant_other_information_cd.applicantOtherInfoId 
 LEFT JOIN applicant_person_relationships AS aprf ON ap.id = aprf.applicantPersonId AND aprf.relationship = 'FATHER' 
 LEFT JOIN applicant_person_relationships AS aprg ON ap.id = aprg.applicantPersonId AND aprg.relationship = 'GUARDIAN' 
 LEFT JOIN applicant_person AS aprel_father ON aprel_father.id = aprf.relatedApplicantPersonId 
 LEFT JOIN applicant_person AS aprel_guardian ON aprel_guardian.id = aprg.relatedApplicantPersonId 
 LEFT JOIN nationalities AS nationalities ON nationalities.id = ap.nationalityId
 LEFT JOIN exam_center_csm ecs on ecs.id=ap.exam_center_csm_id
 LEFT JOIN caste_categories cc on cc.id=ap.casteCategoryId
 LEFT JOIN applicant_transfer_credit_request atcr ON atcr.applicantId=a.id
 LEFT JOIN applicant_transfer_credit_completion atcc ON atcc.applicantId=a.id
 LEFT JOIN courses c_repeat  on c_repeat.id=atcr.courseId and atcr.TransferCreditStatus='REPEAT'
 LEFT JOIN courses c on c.id=atcr.courseId and atcr.status='APPROVE'",
resultColumnsDef = "applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,
application_code,applicant_salutation,birth_date,app_photo_url,Hostel_Applicable,correspondance_language,current_activity,
applicant_salutation_otr_lang,ap_nationalID,ap_primary_email_id,customfield_1,customfield_2,customfield_3,customfield_4,
customfield_5,customfield_6,customfield_7,father_mobileCountryCode,father_mobileNumber,father_emailId,
guardian_mobileCountryCode,guardian_mobileNumber,guardian_mobileNumber,guardian_emailId,student_id,birth_place,
birth_place_language,nationalitie,entry_route,english_proficiency,motivation,ProgramMajor,AdmissionAcademicTerm,
Program_Duration,Exempted_Credit,Expected_Completion_Date,Course_Code,Repeat_Course_Code,category,postNumber,personalIncome"
where id=@dydtDataLineItemId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251118144329__Update_UpdateOfferLetterTCreditData () $$
DROP PROCEDURE IF EXISTS V20251118144329__Update_UpdateOfferLetterTCreditData $$
DELIMITER ;