DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchCreditNoteToBePushed $$
CREATE PROCEDURE netsuiteFetchCreditNoteToBePushed()
BEGIN
# credit note
SELECT 
    bfpr.id AS id,
    u.code AS student,
	u.id AS studentId,
    bill.billNo AS externalId,
    bill.id AS billId,
	bill.billingDate AS date,
	bill.reasonForManualBill AS memo,
    advisorPerson.shortNameOtherLanguage AS salesRep,
	bill.billingDate AS salesEffectiveDate,     
	"Sharjah HO Store" AS warehouse,
	#"Swiss Business School" AS universityName, 
    academy.academyAfrikaans AS universityName,
	#b.batchName AS batch,
	"ONLINE" AS batch,
	#prog.programName AS course,
	"ABS MBA in International Management" AS course,
	#st.seatName AS studyLocation,
	"QATAR" AS studyLocation,
	ad.admissionDate AS dateOfJoining,
	"STUDENT-Active" AS status,
	"Unpaid" AS paymentStatus,
	SUBSTRING_INDEX(fh.feeHeadName, '_', 1) AS item,
	1 AS quantity,
	bfpr.feeAmount AS rate,
	st.seatNameOtherLanguage2 AS taxCode
FROM
    bill_header bill 
    inner join students s on bill.studentId=s.userId
    inner join users u on s.userId=u.id
    inner join persons p on s.personId=p.id
    inner join netsuite_create_customer_mapping nccmap on u.id=nccmap.academiaUserId
    left join netsuite_create_invoice_mapping ncim on bill.id=ncim.billHeaderId
    left join bill_fee_plan_rule_stage bfpr on bill.id=bfpr.billId
    left join fee_stage_head_config fshc on bfpr.feeStageHeadConfigId=fshc.id
    left join fee_heads fh on fshc.feeHeadId=fh.id
    left join admission ad on bill.admissionId=ad.id
    left join academy_location al on ad.academyLocationId = al.id
    left join academies academy on al.academyId=academy.id
    left join users advisorUser on p.advisorId=advisorUser.id
    left join staffs staff on advisorUser.id=staff.userId
    left join persons advisorPerson on staff.personId=advisorPerson.id
    left join prog_batch_seat_config pbsc on bill.programBatchSeatConfigId=pbsc.id
    left join batches b on pbsc.programBatchId=b.id
    left join programs prog on b.programId=prog.id
    left join seat_types st on pbsc.seatTypeId=st.id
    where bill.raiseBillCategory="BILL_PAYABLE" and bill.studentId is not null 
    and bill.billStatus <> "CANCELLED" and ncim.billHeaderId is null
#and bill.id in (63799,63800)
GROUP BY 
    bill.id, bfpr.id
#limit 4
;
END $$ 
DELIMITER ;