DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchCancelInvoiceToBePushed $$
CREATE PROCEDURE netsuiteFetchCancelInvoiceToBePushed()
BEGIN
# cancel invoice
SELECT 
    bh.id AS id,
    bh.billNo AS billNo,
    ncim.id AS netsuiteInvoiceMappingId,
    ncim.netsuiteInvoiceId AS netsuiteInvoiceId,
    nccm.id AS netsuiteCustomerMappingId,
    nccm.netsuiteCustomerId AS netsuiteCustomerId,
    nccm.academiaUserCode AS studentCode,
    ncim.academiaUserId AS academiaUserId
FROM
    bill_header bh
    inner join netsuite_create_invoice_mapping ncim on bh.id=ncim.billHeaderId
    inner join netsuite_create_customer_mapping nccm on bh.studentId=nccm.academiaUserId  
    
    where bh.billStatus="CANCELLED" and bh.studentId is not null and ncim.isCancelled=false
#and bh.id in (63799,63800)
GROUP BY 
    bh.id
#limit 4
;
END $$ 
DELIMITER ;