DELIMITER $$
DROP PROCEDURE IF EXISTS V20251121174720__Insert_ImportExistingStudentLoderConfig $$
CREATE PROCEDURE V20251121174720__Insert_ImportExistingStudentLoderConfig()
BEGIN

IF NOT EXISTS ((SELECT * FROM import_utility_master WHERE screenName='Import Existing Students' AND code ='importExistingStudents')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) 
VALUES ('Import Existing Students', 'application/importExistingStudents', 'importExistingStudents', '1');
END IF; 

IF EXISTS ((SELECT * FROM import_utility_master WHERE screenName='Import Existing Students' AND code ='importExistingStudents')) THEN 
SET @importUtilityMasterId=(SELECT id FROM import_utility_master WHERE screenName='Import Existing Students' AND code ='importExistingStudents');

#-------------------------Is School------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='ACADEMY_LOCATION_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='STUDENT_ID_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('STUDENT_ID_HEADER', 'Student ID / Code', 'Student ID / Code', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('EXTERNAL_SYSTEM_REFERENCE_HEADER', 'External System Reference', 'External System Reference', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PROGRAM_HEADER', 'Program', 'Program', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='BATCH_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('BATCH_HEADER', 'Batch', 'Batch', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='SEAT_TYPE_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SEAT_TYPE_HEADER', 'Seat Type', 'Seat Type', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PERIOD_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PERIOD_HEADER', 'Period', 'Period', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='SECTION_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SECTION_HEADER', 'Section', 'Section', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='ADMISSION_DATE_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ADMISSION_DATE_HEADER', 'Admission Date', 'Admission Date', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;



#-------------------------Is College------------------------------------------------------------------------------------------


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='ACADEMY_LOCATION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='STUDENT_ID_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('STUDENT_ID_HEADER', 'Student ID / Code', 'Student ID / Code', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='EXTERNAL_SYSTEM_REFERENCE_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('EXTERNAL_SYSTEM_REFERENCE_HEADER', 'External System Reference', 'External System Reference', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PROGRAM_HEADER', 'Program', 'Program', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='BATCH_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('BATCH_HEADER', 'Batch', 'Batch', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='SEAT_TYPE_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SEAT_TYPE_HEADER', 'Seat Type', 'Seat Type', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PERIOD_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PERIOD_HEADER', 'Period', 'Period', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='SECTION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SECTION_HEADER', 'Section', 'Section', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='ADMISSION_DATE_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ADMISSION_DATE_HEADER', 'Admission Date', 'Admission Date', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;
END IF;


END $$
CALL V20251121174720__Insert_ImportExistingStudentLoderConfig() $$
DROP PROCEDURE IF EXISTS V20251121174720__Insert_ImportExistingStudentLoderConfig $$
DELIMITER ;