DELIMITER $$
DROP PROCEDURE IF EXISTS V20251124134511__Insert_INDUSMarksheetFormatRepeater $$
CREATE PROCEDURE V20251124134511__Insert_INDUSMarksheetFormatRepeater()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet');

IF NOT EXISTS(select * from report_template where templateCode = 'INDUS_MARKSHEET_FORMAT_REPEATER') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'INDUS_MARKSHEET_FORMAT_REPEATER', 'INDUS Marksheet Format Repeater', 'INDUS_MARKSHEET_FORMAT_REPEATER.png', 'INDUS_MARKSHEET_FORMAT_REPEATER_CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'INDUS_MARKSHEET_FORMAT_REPEATER.jasper', 'AcademiaLogo.png');
END IF; 

set @tempId = (select max(id) from report_template where templateCode='INDUS_MARKSHEET_FORMAT_REPEATER');


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_NAME', 'NAME', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ENROLL_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ENROLL_NO', 'ENROLLMENT NUMBER', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_INSTITUTE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_INSTITUTE', 'INSTITUTE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_EXAM_YEAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_EXAM_YEAR', 'EXAM YEAR', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PROGRAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PROGRAM', 'PROGRAM', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_BRANCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_BRANCH', 'BRANCH/COURSE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SEMESTER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SEMESTER', 'SEMESTER', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PSGR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PSGR', 'PROVISIONAL SEMESTER GRADE REPORT', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUBJECT_CODE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUBJECT_CODE', 'SUBJECT CODE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SUBJECT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SUBJECT_NAME', 'SUBJECT NAME', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CREDIT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CREDIT', 'CREDIT', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MAX_MARKS1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MAX_MARKS1', 'MAX. MARKS', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MIN_MARKS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MIN_MARKS', 'MIN. MARKS', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MARKS_OBTAINED1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MARKS_OBTAINED1', 'MARKS OBTAINED', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TOTAL_MARKS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TOTAL_MARKS', 'TOTAL MARKS', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MAX_MARKS2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MAX_MARKS2', 'MAX. MARKS', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MARKS_OBTAINED2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MARKS_OBTAINED2', 'MARKS OBTAINED', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE', 'GRADE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE_PT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE_PT', 'GRADE POINT', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CSB') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CSB', 'CURRENT SEMESTER BACKLOGS', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TB') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TB', 'TOTAL BACKLOGS', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SGPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SGPA', 'SGPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CGPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CGPA', 'CGPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_FGPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_FGPA', 'FGPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_RESULT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_RESULT', 'RESULT', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PDT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PDT', 'PRINT DATE & TIME :', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PRINTED_BY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PRINTED_BY', 'PRINTED BY :COE ', '1', now());
END IF;

END $$
CALL V20251124134511__Insert_INDUSMarksheetFormatRepeater() $$
DROP PROCEDURE IF EXISTS V20251124134511__Insert_INDUSMarksheetFormatRepeater $$
DELIMITER ;