DELIMITER $$
DROP PROCEDURE IF EXISTS V20251125141524__Create_CsmTshirtSize $$
CREATE PROCEDURE V20251125141524__Create_CsmTshirtSize()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.tables       WHERE table_schema = DATABASE()    AND table_name = 'csm_tshirt_size')) THEN 
CREATE TABLE `csm_tshirt_size` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `itemCode` VARCHAR(100) NOT NULL,     -- Size Code
    `itemValue` VARCHAR(100) NOT NULL,    -- Display Label
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP 
         ON UPDATE CURRENT_TIMESTAMP,

    PRIMARY KEY (`id`),

    UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
    UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),

    KEY `fk_tshirt_size_lastUpdatedBy_idx` (`lastUpdatedBy`),

    CONSTRAINT `fk_tshirt_size_lastUpdatedBy`
        FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId = (SELECT MAX(id) FROM standard_master);

-- ============================================================
-- CREATE MASTER: csm_tshirt_size
-- ============================================================
IF NOT EXISTS (
    (SELECT * FROM standard_master 
     WHERE tableName = 'csm_tshirt_size')
) THEN

INSERT INTO `standard_master`
(`id`, `childMaster`, `tableName`, `masterName`, `moduleName`, `filterCode`,
 `whetherChild`, `whetherParent`, `droolsAgenda`,
 `lastUpdatedBy`, `lastUpdate`) 
VALUES 
(@standardMasterMaxId + 1, NULL,
 'csm_tshirt_size', 'CSM_TSHIRT_SIZE', 'Students', 'COMMON_MASTER',
 0, 0, NULL,
 1, @currentTimeStamp);

END IF;


-- ============================================================
-- INSERT CSM FIELDS
-- ============================================================
IF EXISTS (
    (SELECT * FROM standard_master 
     WHERE tableName = 'csm_tshirt_size')
) THEN

SET @standardMasterId = (
    SELECT id FROM standard_master 
    WHERE tableName = 'csm_tshirt_size'
);

-- ============================================================
-- FIELD 1 : SIZE_CODE  (Item Code)
-- ============================================================
IF NOT EXISTS (
    (SELECT * FROM standard_master_items 
     WHERE standardMasterId = @standardMasterId 
     AND fieldLabel = 'SIZE_CODE')
) THEN

INSERT INTO `standard_master_items`
(`dbFieldName`, `fieldLabel`, `standardMasterId`,
 `fieldType`, `emunType`, `diaplayOrder`,
 `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`,
 `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,
 `validationType`, `maxLength`, `minLength`,
 `lastUpdatedBy`, `lastUpdate`)
VALUES
('code', 'SIZE_CODE', @standardMasterId,
 'Varchar', NULL, 1,
 0, NULL, NULL, NULL,
 0, 0, 0,
 NULL, NULL, NULL,
 1, NOW());

END IF;


-- ============================================================
-- FIELD 2 : DISPLAY_LABEL (Item Value)
-- ============================================================
IF NOT EXISTS (
    (SELECT * FROM standard_master_items 
     WHERE standardMasterId = @standardMasterId 
     AND fieldLabel = 'DISPLAY_LABEL')
) THEN

INSERT INTO `standard_master_items`
(`dbFieldName`, `fieldLabel`, `standardMasterId`,
 `fieldType`, `emunType`, `diaplayOrder`,
 `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`,
 `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,
 `validationType`, `maxLength`, `minLength`,
 `lastUpdatedBy`, `lastUpdate`)
VALUES
('value', 'DISPLAY_LABEL', @standardMasterId,
 'Varchar', NULL, 2,
 0, NULL, NULL, NULL,
 0, 0, 0,
 NULL, NULL, NULL,
 1, NOW());
END IF;
END IF;

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS (select * from ui_translation where ui_translation.objectName='TRANSLATIONS' and keyName='DISPLAY_LABEL') THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ( 'TRANSLATIONS', 'DISPLAY_LABEL', 'Display Label','Display Label','Vertoon etiket','Nhãn hiển thị', now(), '1');
END IF;


IF NOT EXISTS (select * from ui_translation where ui_translation.objectName='TRANSLATIONS' and keyName='SIZE_CODE') THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ( 'TRANSLATIONS', 'SIZE_CODE', 'Size code','Size code','Grootte kode','Mã kích thước', now(), '1');
END IF; 




END $$
CALL V20251125141524__Create_CsmTshirtSize () $$ 
DROP PROCEDURE IF EXISTS V20251125141524__Create_CsmTshirtSize $$ 
DELIMITER ;