DELIMITER $$
DROP PROCEDURE IF EXISTS V20251127135442__Insert_Comment_Column_Trans $$
CREATE PROCEDURE V20251127135442__Insert_Comment_Column_Trans()
BEGIN

IF NOT EXISTS ( SELECT * FROM ui_translation WHERE keyName = 'CURRENT_COMMUNITY' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation ( objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'CURRENT_COMMUNITY','Current Community', 'Current Community','Huidige gemeenskap', 'Cộng đồng hiện tại', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'PAST_COMMUNITY' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'PAST_COMMUNITY','Past Community', 'Past Community','Verlede gemeenskap', 'Cộng đồng trước đây', NOW(), 1
);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation  WHERE keyName = 'COMMUNITY_DETAILS' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation ( objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'COMMUNITY_DETAILS','Community Details', 'Community Details','Gemeenskap Besonderhede', 'Chi tiết cộng đồng', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'COMMUNITY_NAME'  AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'COMMUNITY_NAME','Community Name', 'Community Name','Gemeenskapsnaam', 'Tên cộng đồng', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'COMMUNITY_SERVICES' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'COMMUNITY_SERVICES','Community Services', 'Community Services','Gemeenskapsdienste', 'Dịch vụ cộng đồng', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'OPT_IN' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'OPT_IN','Opt-In', 'Opt-In','Intekening', 'Chọn tham gia', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation  WHERE keyName = 'OPT_OUT' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'OPT_OUT','Opt-Out', 'Opt-Out','Opt-out', 'Chọn không tham gia', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'COMMUNITIES_HISTORY' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'COMMUNITIES_HISTORY','Communities History', 'Communities History','Gemeenskappe Geskiedenis', 'Lịch sử cộng đồng', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'COMMUNITY_OPT_ADD_SUCCESS' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'COMMUNITY_OPT_ADD_SUCCESS','Community opt in/opt out added successfully',
    'Community opt in/opt out added successfully', 'Gemeenskap se intekening/uittekening suksesvol bygevoeg','Đã thêm thành công tùy chọn tham gia/không tham gia cộng đồng', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'COMMUNITY_OPT_UPDATE_SUCCESS' AND objectName = 'STUDENTRESPONSIVEPORTAL') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL', 'COMMUNITY_OPT_UPDATE_SUCCESS','Community opt in/opt out updated successfully',
	'Community opt in/opt out updated successfully','Gemeenskap se intekening/uittekening suksesvol opgedateer','Đã cập nhật thành công tùy chọn tham gia/không tham gia cộng đồng', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'COMMENT'  AND objectName = 'TRANSLATIONS') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('TRANSLATIONS', 'COMMENT','Comment', 'Comment','Lewer kommentaar', 'Bình luận', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE keyName = 'RPT_STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT'  AND objectName = 'TRANSLATIONS') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('TRANSLATIONS', 'RPT_STUDENT_EXTRA_CURRICULAR_ACTIVITY_REPORT','Student Extracurricular Activity Report', 'Student Extracurricular Activity Report','Student Buitemuurse Aktiwiteitsverslag', 'Báo cáo hoạt động ngoại khóa của học sinh', NOW(), 1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='LIST_PROGRAM_PERIOD')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','LIST_PROGRAM_PERIOD',' List of Program Period',' List of Program Period',' Lys van Programperiode',' Danh sách thời gian chương trình',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_START_DATE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PERIOD_START_DATE','Period Start Date','Period Start Date','Periode Begindatum','Ngày bắt đầu kỳ',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_END_DATE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PERIOD_END_DATE','Period End Date','Period End Date','Periode Einddatum','Ngày kết thúc kỳ',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='REGISTRATION_START_DATE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','REGISTRATION_START_DATE','Registration Start Date','Registration Start Date','Registrasie Begindatum','Ngày bắt đầu đăng ký',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='REGISTRATION_END_DATE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','REGISTRATION_END_DATE','Registration End Date','Registration End Date','Registrasie Einddatum','Ngày kết thúc đăng ký',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='LAST_DATE_OF_ENROLLMENT')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','LAST_DATE_OF_ENROLLMENT','Last Date of Enrolment','Last Date of Enrolment','Laaste Datum van Inskrywing','Ngày cuối cùng đăng ký',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_ENROLLMENT_STATUS')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PERIOD_ENROLLMENT_STATUS','Period Enrollment Status','Period Enrollment Status','Periode-inskrywingsstatus','Trạng thái ghi danh theo kỳ',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PROMOTION_STATUS')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PROMOTION_STATUS','Promotion Status','Promotion Status','Promosiestatus','Trạng thái thăng chức',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='REGISTRATION_STATUS')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','REGISTRATION_STATUS','Registration Status','Registration Status','Registrasiestatus','Trạng thái đăng ký',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_NAME')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PERIOD_NAME','Period Name','Period Name','Periode Naam','Tên thời kỳ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_ENROLLED_SUCCESS')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PERIOD_ENROLLED_SUCCESS','You have been enrolled in the selected period successfully','You have been enrolled in the selected period successfully','Jy is suksesvol ingeskryf vir die gekose periode','Bạn đã đăng ký thành công vào thời gian đã chọn',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_ENROLLED_ERROR')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PERIOD_ENROLLED_ERROR','Enrollment could not be processed. Check your details and try again.','Enrollment could not be processed. Check your details and try again.','Inskrywing kon nie verwerk word nie. Kontroleer jou besonderhede en probeer weer.','Không thể xử lý việc đăng ký. Vui lòng kiểm tra thông tin của bạn và thử lại.',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PAYMENTALERT')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('STUDENTRESPONSIVEPORTAL','PAYMENTALERT','Are you sure, you want to make payment of [AMOUNT]','Are you sure, you want to make payment of [AMOUNT]','Is jy seker dat jy betaling van [BEDRAG] wil maak?','Bạn có chắc chắn muốn thanh toán số tiền [SỐ TIỀN] không?',now(),1);
END IF;

END $$
CALL V20251127135442__Insert_Comment_Column_Trans() $$
DROP PROCEDURE IF EXISTS V20251127135442__Insert_Comment_Column_Trans $$
DELIMITER ;