DELIMITER $$
DROP PROCEDURE IF EXISTS V20251223113559__Create_terms_and_condition_url $$
CREATE PROCEDURE V20251223113559__Create_terms_and_condition_url()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'terms_and_condition_url') THEN
CREATE TABLE IF NOT EXISTS `terms_and_condition_url` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `termsAndConditionCSMId` BIGINT(20) NULL,
    `linkTitle` VARCHAR(255) DEFAULT NULL,
    `link` VARCHAR(255) DEFAULT NULL,
    `lastUpdatedBy` BIGINT DEFAULT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
     PRIMARY KEY (`id`),
     FOREIGN KEY (`termsAndConditionCSMId`) REFERENCES `terms_and_condition`(`id`),
     KEY `terms_and_condition_url_lastUpdatedBy` (`lastUpdatedBy`),
     CONSTRAINT `terms_and_condition_url_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
    );
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'terms_and_condition_url')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'terms_and_condition_url','TERMS_AND_CONDITION_URL','Tools & Services','COMMON_MASTER',1,0,1,SYSDATE());
		
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='terms_and_condition_url');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='terms_and_condition';
		SET SQL_SAFE_UPDATES = 1;
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'linkTitle', 'LINKTITLE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'link', 'LINK', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());

END IF;		

END $$
CALL V20251223113559__Create_terms_and_condition_url () $$ 
DROP PROCEDURE IF EXISTS V20251223113559__Create_terms_and_condition_url $$ 
DELIMITER ;