DELIMITER $$
DROP PROCEDURE IF EXISTS V20251223163050__Insert_studentPreferenceEnrollment $$
CREATE PROCEDURE V20251223163050__Insert_studentPreferenceEnrollment()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_preference_enrollment') THEN 
CREATE TABLE `student_preference_enrollment` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `academyLocationId` BIGINT DEFAULT NULL,
    `studentId` BIGINT DEFAULT NULL,
    `admissionId` BIGINT DEFAULT NULL,
    `programId` BIGINT DEFAULT NULL,
    `programBatchId` BIGINT DEFAULT NULL,
    `periodId` BIGINT DEFAULT NULL,
    `courseId` BIGINT DEFAULT NULL,
    `courseVarientId` BIGINT DEFAULT NULL,
    `sectionId` BIGINT DEFAULT NULL,
    `priority` BIGINT DEFAULT NULL,
    `isEnroll` BIT(1) DEFAULT b'0',
    `version` BIGINT DEFAULT NULL,
    `lastUpdate` TIMESTAMP NOT NULL 
        DEFAULT CURRENT_TIMESTAMP 
        ON UPDATE CURRENT_TIMESTAMP,
    `lastUpdatedBy` BIGINT DEFAULT NULL,
    PRIMARY KEY (`id`),
	UNIQUE KEY `uk_spe_course_courseVariant_section` (`courseId`, `courseVarientId`, `sectionId`),
    INDEX `fk_spe_academyLocationId_idx` (`academyLocationId` ASC),
    INDEX `fk_spe_studentId_idx` (`studentId` ASC),
    INDEX `fk_spe_admissionId_idx` (`admissionId` ASC),
    INDEX `fk_spe_programId_idx` (`programId` ASC),
    INDEX `fk_spe_programBatchId_idx` (`programBatchId` ASC),
    INDEX `fk_spe_periodId_idx` (`periodId` ASC),
    INDEX `fk_spe_courseId_idx` (`courseId` ASC),
    INDEX `fk_spe_courseVarientId_idx` (`courseVarientId` ASC),
    INDEX `fk_spe_sectionId_idx` (`sectionId` ASC),
    INDEX `fk_spe_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),

    CONSTRAINT `fk_spe_academyLocationId`
        FOREIGN KEY (`academyLocationId`)
        REFERENCES `academy_location` (`id`),

    CONSTRAINT `fk_spe_studentId`
        FOREIGN KEY (`studentId`)
        REFERENCES `students` (`userId`),

    CONSTRAINT `fk_spe_admissionId`
        FOREIGN KEY (`admissionId`)
        REFERENCES `admission` (`id`),

    CONSTRAINT `fk_spe_programId`
        FOREIGN KEY (`programId`)
        REFERENCES `programs` (`id`),

    CONSTRAINT `fk_spe_programBatchId`
        FOREIGN KEY (`programBatchId`)
        REFERENCES `batches` (`id`),

    CONSTRAINT `fk_spe_periodId`
        FOREIGN KEY (`periodId`)
        REFERENCES `prog_batch_period_config` (`id`),

    CONSTRAINT `fk_spe_courseId`
        FOREIGN KEY (`courseId`)
        REFERENCES `courses` (`id`),

    CONSTRAINT `fk_spe_courseVarientId`
        FOREIGN KEY (`courseVarientId`)
        REFERENCES `course_variants` (`id`),

    CONSTRAINT `fk_spe_sectionId`
        FOREIGN KEY (`sectionId`)
        REFERENCES `sections` (`id`),

    CONSTRAINT `fk_spe_lastUpdatedBy`
        FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE NO ACTION
        ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20251223163050__Insert_studentPreferenceEnrollment() $$
DROP PROCEDURE IF EXISTS V20251223163050__Insert_studentPreferenceEnrollment $$
DELIMITER ;