DELIMITER $$
DROP PROCEDURE IF EXISTS V20251224123004__Create_FatherMotherGuardReceiptAcknoRcpt $$
CREATE PROCEDURE V20251224123004__Create_FatherMotherGuardReceiptAcknoRcpt()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select MAX(id) from dtprovider where dataProviderName="FATHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT")) THEN
SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="FATHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT");
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="FATHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT") THEN
update sql_dtprovider set sqlQuery="SELECT
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T1.`receiptNo` AS RECEIPT_NO,
    T7.`emailId` AS EMAIL_ID,
    T7.`mobileNumber` AS MOBILE_NO,
    T7.`mobileCountryCode` AS MOBILE_CODE,
    CAST(T1.amount AS DECIMAL(65,2)) AS TOTAL_AMOUNT,
    T6.`currencyCode` AS CURRENCY_CODE,
    T8.`code` AS STUDENT_ID,
    T9.`displayName` AS ACADEMY_NAME,
    T7.`printName` AS FATHER_NAME,
    DATE_FORMAT(T1.`transactionDate`, '%d-%m-%Y') AS RECEIPT_DATE
FROM
    receipt_header T1
       LEFT JOIN
    students T2 ON T2.userId = T1.studentId
      LEFT JOIN
    users T8 ON T2.userId = T8.id
         LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    academy_location T9 ON T9.id = T1.academyLocationId    
LEFT JOIN
    person_relationships T5 ON T3.id = T5.personId
LEFT JOIN
    persons T7 ON T5.relatedPersonId = T7.id
        LEFT JOIN
    salutations T4 ON T4.id = T7.salutationId
         LEFT JOIN
    currency T6 ON T6.id = T1.currencyId
LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
T1.id IN (namedParams)
and T5.relationship='FATHER' and T5.whetherDeleted=false group by T1.id"   
where dataProviderId=@dtProviderId;  
END IF;
END IF; 

IF EXISTS ((select MAX(id) from dtprovider where dataProviderName="MOTHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT")) THEN
SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="MOTHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT");
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="MOTHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT") THEN
update sql_dtprovider set sqlQuery="SELECT
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T1.`receiptNo` AS RECEIPT_NO,
    T7.`emailId` AS EMAIL_ID,
    T7.`mobileNumber` AS MOBILE_NO,
    T7.`mobileCountryCode` AS MOBILE_CODE,
    CAST(T1.amount AS DECIMAL(65,2)) AS TOTAL_AMOUNT,
    T6.`currencyCode` AS CURRENCY_CODE,
    T8.`code` AS STUDENT_ID,
    T9.`displayName` AS ACADEMY_NAME,
    T7.`printName` AS MOTHER_NAME,
    DATE_FORMAT(T1.`transactionDate`, '%d-%m-%Y') AS RECEIPT_DATE
FROM
    receipt_header T1
       LEFT JOIN
    students T2 ON T2.userId = T1.studentId
      LEFT JOIN
    users T8 ON T2.userId = T8.id
         LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    academy_location T9 ON T9.id = T1.academyLocationId    
LEFT JOIN
    person_relationships T5 ON T3.id = T5.personId
LEFT JOIN
    persons T7 ON T5.relatedPersonId = T7.id
        LEFT JOIN
    salutations T4 ON T4.id = T7.salutationId
         LEFT JOIN
    currency T6 ON T6.id = T1.currencyId
LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
T1.id IN (namedParams)
and T5.relationship='MOTHER' and T5.whetherDeleted=false group by T1.id"   
where dataProviderId=@dtProviderId;  
END IF;
END IF;

IF EXISTS ((select MAX(id) from dtprovider where dataProviderName="GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT")) THEN
SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT");
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT") THEN
update sql_dtprovider set sqlQuery="SELECT
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T1.`receiptNo` AS RECEIPT_NO,
    T7.`emailId` AS EMAIL_ID,
    T7.`mobileNumber` AS MOBILE_NO,
    T7.`mobileCountryCode` AS MOBILE_CODE,
    CAST(T1.amount AS DECIMAL(65,2)) AS TOTAL_AMOUNT,
    T6.`currencyCode` AS CURRENCY_CODE,
    T8.`code` AS STUDENT_ID,
    T9.`displayName` AS ACADEMY_NAME,
    T7.`printName` AS GUARDIAN_NAME,
    DATE_FORMAT(T1.`transactionDate`, '%d-%m-%Y') AS RECEIPT_DATE
FROM
    receipt_header T1
       LEFT JOIN
    students T2 ON T2.userId = T1.studentId
      LEFT JOIN
    users T8 ON T2.userId = T8.id
         LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    academy_location T9 ON T9.id = T1.academyLocationId    
LEFT JOIN
    person_relationships T5 ON T3.id = T5.personId
LEFT JOIN
    persons T7 ON T5.relatedPersonId = T7.id
        LEFT JOIN
    salutations T4 ON T4.id = T7.salutationId
         LEFT JOIN
    currency T6 ON T6.id = T1.currencyId
LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
T1.id IN (namedParams)
and T5.relationship='GUARDIAN' and T5.whetherDeleted=false group by T1.id"
where dataProviderId=@dtProviderId;  
END IF; 
END IF;  
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251224123004__Create_FatherMotherGuardReceiptAcknoRcpt () $$ 
DROP PROCEDURE IF EXISTS V20251224123004__Create_FatherMotherGuardReceiptAcknoRcpt $$ 
DELIMITER ;