DELIMITER $$
DROP PROCEDURE IF EXISTS createCertificateViaPrivysealToBePushed $$
CREATE PROCEDURE createCertificateViaPrivysealToBePushed()
BEGIN

SELECT 
   progCompDetails.id AS id,
aa.itemValue AS certificateId, #credential id
stu.userId AS studentId,
stuPer.emailId AS email,
u.code AS studentCode,
stuPer.printName AS printName,
CONCAT(COALESCE(stuPer.mobileCountryCode, ''),
            COALESCE(stuPer.mobileNumber, '')) AS mobileNumber,
progCompDetails.awardNominatedPerson AS idNumber,
stuPer.nationalID AS passportNumber,
progCompDetails.isAlumni AS isNotEligible,
CASE 
    WHEN spec.itemValue = 'Yes' THEN 'true'
    WHEN spec.itemValue = 'No'  THEN 'false'
    ELSE NULL
END AS withDistinction,
progCompDetails.awardCertificate AS certificateNumber,
progCompDetails.awardGivenDate AS dateIssued,
p.programDesignator AS deanAndDirector,
p.programQualifier AS academicAndGovernanceDirector,
p.saqaId AS saqaId,
p.programRegistrationId AS signatory2Name,
'Director of Development and Alumni Henley Business School' AS signatory2Title,
p.programSecondQualifier AS signatory1Name,
'Dean, Henley Africa' AS signatory1Title,
org.orgName AS schoolName,
progCompDetails.admissionId AS admissionId,
progCompDetails.personId AS personId,
progCompDetails.programId AS programId,
progCompDetails.batchId AS batchId,
progCompDetails.semester AS periodId,
p.programName AS programName,
a.code AS admissionCode
FROM
    program_completion_details AS progCompDetails
        LEFT JOIN
        privyseal_certificate_mapping privyCMapping ON privyCMapping.programCompletionDetailId=progCompDetails.id
        INNER JOIN
        programs p ON progCompDetails.programId = p.id
        INNER JOIN
        batches b ON progCompDetails.batchId = b.id
        INNER JOIN
        prog_batch_period_config pbpc ON b.id=pbpc.programBatchId
        INNER JOIN
        academic_award aa ON p.academicAwardId=aa.id
        INNER JOIN
        users u ON progCompDetails.studentId = u.code
        INNER JOIN 
        students stu ON u.id=stu.userId
        INNER JOIN
		persons stuPer ON stu.personId = stuPer.id
        INNER JOIN
        admission a ON stu.userId = a.studentId
        INNER JOIN
        academy_location al ON a.academyLocationId = al.id
        INNER JOIN
        academies academy ON al.academyId = academy.id
        INNER JOIN
        organizations org ON academy.organizationId = org.id
        LEFT JOIN
        id_type idType ON stuPer.idTypeId = idType.id
        LEFT JOIN
		student_specialization_csm spec ON progCompDetails.specializationId=spec.id
    
    WHERE privyCMapping.programCompletionDetailId IS NULL 
    and idType.idTypeCode='Passport'
    
GROUP BY progCompDetails.id;
END $$ 
DELIMITER ;