DELIMITER $$
DROP PROCEDURE IF EXISTS V20251231172212__Update_studentCourseEnrollmentRegDyn $$
CREATE PROCEDURE V20251231172212__Update_studentCourseEnrollmentRegDyn()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @dataProviderId=(select id from dydt_data_provider where providerName="Registration Confirmation Letter Dynamic Document" limit 1);
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' and dataProviderId=@dataProviderId limit 1)) THEN 
update dydt_data_line_item set 
sqlWhereQueryDef = "WHERE adm.id=PRM_ADMISSION_ID 
      AND (
            (LOWER(dd.value)='no' 
             AND sce.programBatchPeriodConfigId>=(
                 SELECT pbs.progBatchPeriodConfigId 
                 FROM program_batch_students pbs 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             )) 
            OR 
            (LOWER(dd.value)='yes' 
             AND py.id=(
                 SELECT pyp.id 
                 FROM program_batch_students pbs 
                 JOIN prog_batch_period_config pbpcp ON pbs.progBatchPeriodConfigId=pbpcp.id 
                 INNER JOIN period_year pyp ON pbpcp.periodYearId=pyp.id 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             ))
          )
      AND sce.exitDate IS NULL 
      AND adm.activeStatus=true  

    UNION ALL

    SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
           IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
           FLOOR(c.courseCredits) AS COURSE_CREDITS, 
           pbpc.printName AS PERIOD,
           ss.examDate AS EXAM_DATE, 
           DATE_FORMAT(ss.examStartTime,'%h:%i %p') AS EXAM_START_TIME, 
           DATE_FORMAT(ss.examEndTime,'%h:%i %p') AS EXAM_END_TIME,
           IF(program_courses.isOfferedYearly = 1,'Yes','No') AS YEARLY_MODULE,
           bh.totalAmount as COURSE_ENROLLMENT_BILL_AMOUNT,
           sce1.enrollCourseStatus as MODULE_TYPE,
           'Withdrawn' as ENROLLMENT_STATUS,
           pbpc.id AS PERIOD_ID,   -- used only for grouping & ordering
           c.id AS COURSE_ID
    FROM prog_batch_course_details sce
    JOIN student_course_enrollment sce1 
         ON sce1.admissionId=sce.admissionId 
        AND sce1.courseVarientId=sce.courseVarientId 
        AND sce.sectionId=sce1.sectionId 
        AND sce1.programBatchPeriodConfigId=sce.programBatchPeriodConfigId 
        AND sce.whetherDeEnrolled=true
    INNER JOIN prog_batch_period_config pbpc ON sce.programBatchPeriodConfigId=pbpc.id
    LEFT JOIN period_year py ON pbpc.periodYearId=py.id
    INNER JOIN drop_down dd ON dd.name='Yearly Proof of Registration'
    INNER JOIN admission adm ON adm.id=sce.admissionId
    INNER JOIN course_variants cv ON cv.id=sce.courseVarientId
    INNER JOIN sections ss ON ss.id = sce.sectionId
    LEFT JOIN courses c ON c.id=cv.courseId
    LEFT JOIN courses co ON co.id = c.parentCourseId
    LEFT JOIN program_courses ON (c.parentCourseId = program_courses.courseId OR c.id=program_courses.courseId)
                              AND pbpc.programBatchId = program_courses.programBatchId
    LEFT JOIN bill_header bh ON sce1.billId=bh.id
    WHERE adm.id=PRM_ADMISSION_ID 
      AND (
            (LOWER(dd.value)='no' 
             AND sce.programBatchPeriodConfigId>=(
                 SELECT pbs.progBatchPeriodConfigId 
                 FROM program_batch_students pbs 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             )) 
            OR 
            (LOWER(dd.value)='yes' 
             AND py.id=(
                 SELECT pyp.id 
                 FROM program_batch_students pbs 
                 JOIN prog_batch_period_config pbpcp ON pbs.progBatchPeriodConfigId=pbpcp.id 
                 INNER JOIN period_year pyp ON pbpcp.periodYearId=pyp.id 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             ))
          )
      AND adm.activeStatus=true
) AS unioned
GROUP BY  unioned.COURSE_ID
ORDER BY unioned.PERIOD_ID ASC"

where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' and dataProviderId=@dataProviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251231172212__Update_studentCourseEnrollmentRegDyn () $$
DROP PROCEDURE IF EXISTS V20251231172212__Update_studentCourseEnrollmentRegDyn $$
DELIMITER ;