DELIMITER $$
DROP PROCEDURE IF EXISTS V20260102170304__Insert_StandardizeGridNames $$
CREATE PROCEDURE V20260102170304__Insert_StandardizeGridNames()
BEGIN

-- LIST_OF_BATCHES
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_BATCHES') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_BATCHES','List of Batches','List of Batches','Lys van groepe','Danh sách các lô',NOW(),1);
END IF;

-- LIST_OF_BATCHES_CREATED
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_BATCHES_CREATED') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_BATCHES_CREATED','List of Batches Created','List of Batches Created','Lys van Groepe Geskep','Danh sách các lô đã tạo',NOW(),1);
END IF;

-- LIST_OF_PERIOD_ASSOCIATED
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_PERIOD_ASSOCIATED') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_PERIOD_ASSOCIATED','List of Periods Associated','List of Periods Associated','Lys van geassosieerde periodes','Danh sách các khoảng thời gian liên quan',NOW(),1);
END IF;

-- LIST_OF_ASSOCIATED_EXAM_CENTERS
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_ASSOCIATED_EXAM_CENTERS') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_ASSOCIATED_EXAM_CENTERS','List of Associated Exam Centers','List of Associated Exam Centers','Lys van Geassosieerde Eksamensentrums','Danh sách các trung tâm khảo thí liên kết',NOW(),1);
END IF;

-- LIST_OF_SECTION_ASSOCIATED
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_SECTION_ASSOCIATED') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_SECTION_ASSOCIATED','List of Sections Associated','List of Sections Associated','Lys van Geassosieerde Afdelings','Danh sách các phần liên quan',NOW(),1);
END IF;

-- LIST_OF_SPECIALIZATION_AVAILABLE
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_SPECIALIZATION_AVAILABLE') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_SPECIALIZATION_AVAILABLE','List of Specializations Available','List of Specializations Available','Lys van Beskikbare Spesialisasies','Danh sách các chuyên ngành hiện có',NOW(),1);
END IF;

-- LIST_OF_COURSES
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_COURSES') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_COURSES','List of Courses','List of Courses','Lys van kursusse','Danh sách các khóa học',NOW(),1);
END IF;

-- LIST_OF_COURSES_GROUP
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_COURSES_GROUP') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_COURSES_GROUP','List of Course Groups','List of Course Groups','Lys van kursusgroepe','Danh sách các nhóm khóa học',NOW(),1);
END IF;

-- LIST_OF_SPECIALIZATIONS
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_SPECIALIZATIONS') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_SPECIALIZATIONS','List of Specializations','List of Specializations','Lys van Spesialisasies','Danh sách các chuyên ngành',NOW(),1);
END IF;

-- SPECIALIZATION_REPORT
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='PROGRAMANDCOURSE' AND keyName='SPECIALIZATION_REPORT') THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PROGRAMANDCOURSE','SPECIALIZATION_REPORT','Specialization Report','Specialization Report','Spesialisasieverslag','Báo cáo chuyên môn',NOW(),1);
END IF;

-- LIST_OF_PRE_REQUISITE_NOT_MET_STUDENTS
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='COURSETX' AND keyName='LIST_OF_PRE_REQUISITE_NOT_MET_STUDENTS') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('COURSETX','LIST_OF_PRE_REQUISITE_NOT_MET_STUDENTS','List of Pre-Requisite Not Met Students','List of Pre-Requisite Not Met Students',
 'Lys van Voorvereiste Nie-voldoeningstudente','Danh sách sinh viên chưa đáp ứng điều kiện tiên quyết',NOW(), 1);
END IF;

-- READING_MATERIAL_DISTRIBUTION_LIST
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='PROGRAMANDCOURSE' AND keyName='READING_MATERIAL_DISTRIBUTION_LIST') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('PROGRAMANDCOURSE','READING_MATERIAL_DISTRIBUTION_LIST','Reading Material Distribution List','Reading Material Distribution List',
 'Leesmateriaalverspreidingslys','Danh sách phân phối tài liệu đọc',NOW(), 1);
END IF;

-- LIST_OF_TIME_TABLE_SESSIONS
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='LIST_OF_TIME_TABLE_SESSIONS') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('TRANSLATIONS','LIST_OF_TIME_TABLE_SESSIONS','List of Timetable Sessions','List of Timetable Sessions',
 'Lys van Roostersessies','Danh sách các buổi học theo thời khóa biểu',NOW(), 1);
END IF;

-- COURSE_DETAILS_LIST
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='COURSE_DETAILS_LIST') THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
VALUES ('TRANSLATIONS','COURSE_DETAILS_LIST','Course Details List','Course Details List','Kursusbesonderhedelys','Danh sách chi tiết khóa học',NOW(), 1);
END IF;

END $$
CALL V20260102170304__Insert_StandardizeGridNames() $$
DROP PROCEDURE IF EXISTS V20260102170304__Insert_StandardizeGridNames $$
DELIMITER ;