DELIMITER $$
DROP PROCEDURE IF EXISTS V20260109120717__Update_BuzzCustomdataProvider $$
CREATE PROCEDURE V20260109120717__Update_BuzzCustomdataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_PROGRAM_ID')) THEN 
SET @dydtDataLineItemId=(select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_PROGRAM_ID');
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef` = 'SELECT \n        p.programCode AS program_code,\n        p.programName AS program_name,\n        p.programNameToBePrint AS program_print_name,\n        p.programNameToBePrintLanguageOne AS program_print_name_afr,\n        pd.shortCode AS primary_dept_code,\n        pd.deptName AS primary_dept_name,\n        psd.shortCode AS secondary_dept_code,\n        psd.deptName AS secondary_dept_name,\n        b.batchName AS batch_name,\n        b.startDate AS batch_start_date,\nb.startDate as custom_start_date,\n  bc.cf14 as custom_end_date,\n        b.tillDate AS batch_tilldate,\n        pg.groupName AS program_group_name,\n        DATE_FORMAT(aprgm.schoolAttendanceStartDate,\'%d-%m-%Y\') AS school_attendance_start_date\n    FROM \n        application_program aprgm\n            LEFT JOIN\n        programs p ON aprgm.programId = p.id\n            LEFT JOIN\n        prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id\n            LEFT JOIN\n        batches b ON b.id = pbsc.programBatchId\nleft join batches_cd bc on bc.batchId=b.id\n            LEFT JOIN\n        department pd ON pd.id = p.programDepartmentId\n            LEFT JOIN\n        department psd ON psd.id = p.subDepartmentId\n        \n    		LEFT JOIN\n       program_group pg ON pg.id = p.programGroupId', `resultColumnsDef` = 'program_code,program_name,program_print_name,program_print_name_afr,primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,program_group_name,school_attendance_start_date,custom_start_date,custom_end_date' WHERE id=@dydtDataLineItemId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20260109120717__Update_BuzzCustomdataProvider () $$
DROP PROCEDURE IF EXISTS V20260109120717__Update_BuzzCustomdataProvider $$
DELIMITER ;