DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120114955__Create_EvalPeriodLevelReport $$
CREATE PROCEDURE V20260120114955__Create_EvalPeriodLevelReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='evaluation_period_report')) THEN 
CREATE TABLE evaluation_period_report (
  id bigint NOT NULL AUTO_INCREMENT,
  evaluationGroupId bigint NULL,
  periodId bigint NOT NULL,
  reportType varchar(100) NULL,
  filePath varchar(100) NULL,
  generatedDate DATE NOT NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_evaluation_period_report_evaluationGroup (evaluationGroupId),
  KEY idx_evaluation_period_report_period (periodId),
  KEY idx_evaluation_period_report_users (lastUpdatedBy),
  CONSTRAINT fk_evaluation_period_report_evaluationGroup FOREIGN KEY (evaluationGroupId) REFERENCES evaluation_group (id),
  CONSTRAINT fk_evaluation_period_report_period FOREIGN KEY (periodId) REFERENCES prog_batch_period_config (id),
  CONSTRAINT fk_evaluation_period_report_users FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);

END IF;  

END $$
CALL V20260120114955__Create_EvalPeriodLevelReport () $$ 
DROP PROCEDURE IF EXISTS V20260120114955__Create_EvalPeriodLevelReport $$ 
DELIMITER ;