DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120130520__Create_additional_enrollment_req_detail $$
CREATE PROCEDURE V20260120130520__Create_additional_enrollment_req_detail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='additional_enrollment_request_details')) THEN 
CREATE TABLE `additional_enrollment_request_details` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `serviceRequestId` bigint NULL,
  `admissionId` bigint NOT NULL,
  `studentId` bigint NOT NULL,
  `academicTermId` bigint NOT NULL,
  `progBatchPeriodConfigId` bigint NOT NULL,
  `academyLocationId` bigint NOT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_service_requests` FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests` (`id`),
  CONSTRAINT `fk_admission_add_enroll` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_student_add_enroll` FOREIGN KEY (`studentId`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_academic_term_add_enroll` FOREIGN KEY (`academicTermid`) REFERENCES `academic_term` (`id`),
  CONSTRAINT `fk_prog_batch_period_config_add_enroll` FOREIGN KEY (`progBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_academy_location_add_enroll` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_users_add_enroll` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20260120130520__Create_additional_enrollment_req_detail () $$ 
DROP PROCEDURE IF EXISTS V20260120130520__Create_additional_enrollment_req_detail $$ 
DELIMITER ;