DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120130611__Create_additional_course_group_mapping $$
CREATE PROCEDURE V20260120130611__Create_additional_course_group_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='additional_course_group_mapping')) THEN 
	IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='additional_enrollment_request_details')) THEN 
		CREATE TABLE `additional_course_group_mapping` (
		  `id` bigint NOT NULL AUTO_INCREMENT,
		  `serviceRequestId` bigint NULL,
		  `detailId` bigint NULL,
		  `admissionId` bigint NOT NULL,
		  `studentId` bigint NOT NULL,
		  `courseId` bigint NOT NULL,
		  `courseVariantId` bigint NOT NULL,
		  `isCourseGroup` BIT NULL DEFAULT FALSE,
		  `courseGroupId` bigint NULL,
		  `progBatchPeriodConfigId` bigint NOT NULL,
		  `isApproved` BIT NULL DEFAULT FALSE,
		  `lastUpdatedBy` bigint NOT NULL,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  PRIMARY KEY (`id`),
		  CONSTRAINT `fk_service_requests_1` FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests` (`id`),
		  CONSTRAINT `fk_additional_enrollment_request_details` FOREIGN KEY (`detailId`) REFERENCES `additional_enrollment_request_details` (`id`),
		  CONSTRAINT `fk_admission_grp_map` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
		  CONSTRAINT `fk_student_grp_map` FOREIGN KEY (`studentId`) REFERENCES `users` (`id`),
		  CONSTRAINT `fk_course_grp_map` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
		  CONSTRAINT `fk_course_variants_grp_map` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
		  CONSTRAINT `fk_course_group_grp_map` FOREIGN KEY (`courseGroupId`) REFERENCES `course_group` (`id`),
		  CONSTRAINT `fk_prog_batch_period_config_grp_map` FOREIGN KEY (`progBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`),
		  CONSTRAINT `fk_users_grp_map` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
		) ENGINE=InnoDB;
	END IF; 
END IF; 

END $$
CALL V20260120130611__Create_additional_course_group_mapping () $$ 
DROP PROCEDURE IF EXISTS V20260120130611__Create_additional_course_group_mapping $$ 
DELIMITER ;