DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120193119__Create_TabulationReportsMigrateProcedure $$
CREATE PROCEDURE V20260120193119__Create_TabulationReportsMigrateProcedure()
BEGIN

IF EXISTS (
        SELECT 1
        FROM eval_group_hall_ticket
        WHERE reportType = 'TABULATION_REGISTER'
          AND evaluationGroupId IS NOT NULL
    ) THEN

        INSERT INTO evaluation_period_report (
            evaluationGroupId,
            periodId,
            reportType,
            filePath,
            generatedDate,
            lastUpdatedBy,
            lastUpdate
        )
        SELECT
            eght.evaluationGroupId,
            eght.periodId,
            eght.hallTicketNumber,
            eght.hallTicketPath,
            DATE(eght.lastUpdate),
            eght.lastUpdatedBy,
            eght.lastUpdate
        FROM eval_group_hall_ticket eght
        WHERE eght.reportType = 'TABULATION_REGISTER'
          AND eght.evaluationGroupId IS NOT NULL
          AND NOT EXISTS (
              SELECT 1
              FROM evaluation_period_report epr
              WHERE epr.evaluationGroupId = eght.evaluationGroupId
                AND epr.periodId = eght.periodId
                AND epr.reportType = eght.hallTicketNumber
          ) group by eght.evaluationGroupId,
            eght.periodId,
            eght.hallTicketNumber,
            eght.hallTicketPath,
            eght.lastUpdatedBy,
            eght.lastUpdate;

    END IF;

END $$
CALL V20260120193119__Create_TabulationReportsMigrateProcedure () $$ 
DROP PROCEDURE IF EXISTS V20260120193119__Create_TabulationReportsMigrateProcedure $$ 
DELIMITER ;