DELIMITER $$
DROP PROCEDURE IF EXISTS V20260121152207__Update_StatementOfAccountAdhocEventAdmin $$
CREATE PROCEDURE V20260121152207__Update_StatementOfAccountAdhocEventAdmin()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT') THEN 

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT');

UPDATE sql_dtprovider
set sqlQuery = "
SELECT 
    T1.id AS ID,
     CASE 
        WHEN T2.adminId IS NOT NULL THEN T3.printName
        ELSE T13.printName
    END AS PRINT_NAME,
    CASE 
        WHEN T2.adminId IS NOT NULL THEN T3.firstName
        ELSE T6.firstName
    END AS FIRST_NAME,
    CASE 
        WHEN T2.adminId IS NOT NULL THEN NULL
        ELSE T6.middleName
    END AS MIDDLE_NAME,

    CASE 
        WHEN T2.adminId IS NOT NULL THEN T3.lastName
        ELSE T6.lastName
    END AS LAST_NAME,

    T13.code AS STUDENT_CODE,
    DATE_FORMAT(NOW(), '%d-%m-%Y') AS CURRENT_DATE_TODAY,

    CASE 
        WHEN T2.adminId IS NOT NULL THEN T3.emailId
        ELSE T6.emailId
    END AS EMAIL_ID,
    CASE 
        WHEN T2.adminId IS NOT NULL THEN NULL
        ELSE
            CASE
                WHEN (
                    SELECT FPD.emailHome
                    FROM fee_payer_detail FPD
                    WHERE FPD.personId = T4.personId
                      AND FPD.isPrimaryFeePayer = 1
                    LIMIT 1
                ) IS NOT NULL
                THEN (
                    SELECT FPD.emailHome
                    FROM fee_payer_detail FPD
                    WHERE FPD.personId = T4.personId
                      AND FPD.isPrimaryFeePayer = 1
                    LIMIT 1
                )
                ELSE (
                    SELECT FPD.emailWork
                    FROM fee_payer_detail FPD
                    WHERE FPD.personId = T4.personId
                      AND FPD.payerType = 'CORPORATE'
                      AND FPD.isPrimaryFeePayer = 1
                    LIMIT 1
                )
            END
    END AS ALTERNATE_EMAIL_ID,
    T6.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
    T11.programNameToBePrint AS PROGRAM,
    T11.programNameToBePrintLanguageOne AS PROGRAM_PRINT_NAME_OTHER_LANGUAGE,
    T10.printName AS BATCH,
    T12.seatName AS SEAT_TYPE,
    T12.seatNameOtherLanguage AS SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE,
    T6.printNameOtherLanguage AS STUDENT_PRINT_NAME_OTHER_LANGUAGE,
    T6.firstNameOtherLanguage AS STUDENT_FIRST_NAME_OTHER_LANGUAGE,
    T6.middleNameOtherLanguage AS STUDENT_MIDDLE_NAME_OTHER_LANGUAGE,
    T6.lastNameOtherLanguage AS STUDENT_LAST_NAME_OTHER_LANGUAGE
FROM send_email_account_statement T1
LEFT JOIN statement_email_tab_filter T2 
       ON T1.statementEmailTabFilterId = T2.id
LEFT JOIN users T3 
       ON T2.adminId = T3.id
LEFT JOIN students T4 
       ON T1.studentId = T4.userId
LEFT JOIN persons T6 
       ON T6.id = T4.personId
LEFT JOIN admission T7 
       ON T4.userId = T7.studentId
LEFT JOIN prog_batch_seat_config T8 
       ON T7.programBatchSeatConfigId = T8.id
LEFT JOIN batches T10 
       ON T10.id = T8.programBatchId
LEFT JOIN programs T11 
       ON T11.id = T10.programId
LEFT JOIN seat_types T12 
       ON T8.seatTypeId = T12.id
LEFT JOIN users T13
       ON T4.userId=T13.id
WHERE
    T1.id IN (namedParams)
GROUP BY T13.id ORDER BY T7.admissionDate DESC 
LIMIT 1
",
jsonString = '{
  "id": 1,
  "searchResultViewColumns": [
    {
      "id": 1,
      "value": "id",
      "resultKey": "ID",
      "displayCode": "",
      "displayOrder": 0
    },
    {
      "id": 2,
      "value": "printName",
      "resultKey": "PRINT_NAME",
      "displayCode": "",
      "displayOrder": 1
    },
    {
      "id": 3,
      "value": "firstName",
      "resultKey": "FIRST_NAME",
      "displayCode": "",
      "displayOrder": 2
    },
    {
      "id": 4,
      "value": "middleName",
      "resultKey": "MIDDLE_NAME",
      "displayCode": "",
      "displayOrder": 3
    },
    {
      "id": 5,
      "value": "lastName",
      "resultKey": "LAST_NAME",
      "displayCode": "",
      "displayOrder": 4
    },
    {
      "id": 6,
      "value": "code",
      "resultKey": "STUDENT_CODE",
      "displayCode": "",
      "displayOrder": 5
    },
    {
      "id": 7,
      "value": "Current Date",
      "resultKey": "CURRENT_DATE_TODAY",
      "displayCode": "",
      "displayOrder": 6
    },
    {
      "id": 8,
      "value": "externalSysRefOne",
      "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
      "displayCode": "",
      "displayOrder": 7
    },
    {
      "id": 9,
      "value": "programNameToBePrint",
      "resultKey": "PROGRAM",
      "displayCode": "",
      "displayOrder": 8
    },
    {
      "id": 10,
      "value": "programNameToBePrintLanguageOne",
      "resultKey": "PROGRAM_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 9
    },
    {
      "id": 11,
      "value": "printName",
      "resultKey": "BATCH",
      "displayCode": "",
      "displayOrder": 10
    },
    {
      "id": 12,
      "value": "seatName",
      "resultKey": "SEAT_TYPE",
      "displayCode": "",
      "displayOrder": 11
    },
    {
      "id": 13,
      "value": "seatNameOtherLanguage",
      "resultKey": "SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 12
    },
    {
      "id": 14,
      "value": "printNameOtherLanguage",
      "resultKey": "STUDENT_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 13
    },
    {
      "id": 15,
      "value": "firstNameOtherLanguage",
      "resultKey": "STUDENT_FIRST_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 14
    },
    {
      "id": 16,
      "value": "middleNameOtherLanguage",
      "resultKey": "STUDENT_MIDDLE_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 15
    },
    {
      "id": 17,
      "value": "lastNameOtherLanguage",
      "resultKey": "STUDENT_LAST_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 16
    }
  ]
}'

WHERE dataProviderId = @dtproviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20260121152207__Update_StatementOfAccountAdhocEventAdmin () $$
DROP PROCEDURE IF EXISTS V20260121152207__Update_StatementOfAccountAdhocEventAdmin $$
DELIMITER ;