DELIMITER $$
DROP PROCEDURE IF EXISTS V20260122175301__Create_Course_Add_Info_Student $$
CREATE PROCEDURE V20260122175301__Create_Course_Add_Info_Student()
BEGIN

IF NOT EXISTS ((select * from information_schema.Tables where table_schema=DATABASE() and
table_name='course_additional_information_student')) THEN 
CREATE TABLE `course_additional_information_student` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  
  `courseVarientId` BIGINT DEFAULT NULL,
  `admissionId` BIGINT DEFAULT NULL,
  `sectionId` BIGINT DEFAULT NULL,
  `programBatchPeriodConfigId` BIGINT DEFAULT NULL,

  `additionalInformation` LONGTEXT DEFAULT NULL,

  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL 
      DEFAULT CURRENT_TIMESTAMP 
      ON UPDATE CURRENT_TIMESTAMP,

  PRIMARY KEY (`id`),

  FOREIGN KEY (`courseVarientId`) 
      REFERENCES `course_variants` (`id`),

  FOREIGN KEY (`admissionId`) 
      REFERENCES `admission` (`id`),

  FOREIGN KEY (`sectionId`) 
      REFERENCES `sections` (`id`),

  FOREIGN KEY (`programBatchPeriodConfigId`) 
      REFERENCES `prog_batch_period_config` (`id`),

  FOREIGN KEY (`lastUpdatedBy`) 
      REFERENCES `users` (`id`)
);
END IF; 

END $$
CALL V20260122175301__Create_Course_Add_Info_Student () $$ 
DROP PROCEDURE IF EXISTS V20260122175301__Create_Course_Add_Info_Student $$ 
DELIMITER ;