ALTER TABLE `student_attendance_dashboard_section_wise` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL AFTER `componentId`,
ADD INDEX `fk_student_attendance_dashboard_section_wise_9_idx` (`courseVariantId` ASC);

ALTER TABLE `student_attendance_dashboard_section_wise` 
ADD CONSTRAINT `fk_student_attendance_dashboard_section_wise_9`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

DROP VIEW IF EXISTS student_attendance_dashboard_section_wise_total;

CREATE VIEW `student_attendance_dashboard_section_wise_section` AS
    select 
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_section_wise`.`programId` AS `programId`,
        `student_attendance_dashboard_section_wise`.`batchId` AS `batchId`,
        `student_attendance_dashboard_section_wise`.`periodId` AS `periodId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionCode`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        floor(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100)) AS `presentPercent`,
        floor(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100)) AS `absentPercent`
    from
        (`student_attendance_dashboard_section_wise`
        left join `sections` ON ((`student_attendance_dashboard_section_wise`.`sectionId` = `sections`.`id`)))
    group by `student_attendance_dashboard_section_wise`.`sectionId`;
 
    
 CREATE VIEW `student_attendance_dashboard_section_wise_variant` AS
    select 
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_section_wise`.`courseId` AS `courseId`,
        `student_attendance_dashboard_section_wise`.`courseVariantId` AS `courseVariantId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        floor(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100)) AS `presentPercent`,
        floor(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100)) AS `absentPercent`
    from
        `student_attendance_dashboard_section_wise`
    group by `student_attendance_dashboard_section_wise`.`courseVariantId`;
    
 