
ALTER TABLE question_paper
  DROP FOREIGN KEY Refquestion_paper_structure783;

ALTER TABLE question_paper
DROP INDEX Refquestion_paper_structure783 ;

ALTER TABLE structure_level_one
  DROP FOREIGN KEY Refquestion_paper_structure652;

ALTER TABLE structure_level_one
DROP INDEX Refquestion_paper_structure652 ;


CREATE TABLE `question_paper_structure` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  `structureCode` varchar(255) DEFAULT NULL,
  `structureAssignTo` bigint(20) DEFAULT NULL,
  `maxMarks` double(10,2) DEFAULT NULL COMMENT 'only for display come from detail sequence',
  `maxTime` int(11) DEFAULT NULL COMMENT 'In minutes',
  `numberOfOptionGroup` int(11) DEFAULT NULL COMMENT 'Ex Section A ,Sectiion B',
  `numberOfQuestion` int(11) DEFAULT NULL COMMENT 'Total Number of question for a Structure',
  `designStatus` varchar(45) DEFAULT NULL COMMENT 'Assigned,Submitted,Approved',
  `instruction` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'assigned,submitted,approved',
  PRIMARY KEY (`id`),
  KEY `Refusers1383` (`lastUpdatedBy`),
  KEY `Refevl_detail_seqId_idx` (`evalSequenceDetailId`),
  KEY `RefcreatedBy1342_idx` (`structureAssignTo`),
  CONSTRAINT `RefcreatedBy1342` FOREIGN KEY (`structureAssignTo`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refevl_detail_seqId1232` FOREIGN KEY (`evalSequenceDetailId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers1383` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


