ALTER TABLE application_prog_stage   
  ADD COLUMN whetherUnderReplacement BOOL DEFAULT FALSE  NOT NULL AFTER quotaRank,
  ADD COLUMN replacementStatus VARCHAR(50) NULL AFTER  whetherUnderReplacement;

ALTER TABLE program_selection_process   
  ADD COLUMN whetherReplacementAllowed BIT(1) DEFAULT b'0'  NOT NULL AFTER mandatoryQuotaTypeId;

CREATE TABLE closed_rplcmt_prog_slct_process (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  programSelectionProcessId bigint(20) NOT NULL,
  closedDate timestamp NULL DEFAULT NULL,
  lastUpdatedBy bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_pspid (programSelectionProcessId),
  KEY fk_users_crpsp (lastUpdatedBy),
  CONSTRAINT fk_pspid FOREIGN KEY (programSelectionProcessId) REFERENCES program_selection_process (id),
  CONSTRAINT fk_users_crpsp FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);

CREATE TABLE replacement_list (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  applicantToBeReplacedId bigint(20) NOT NULL,
  applicantToBeSelectedId bigint(20) NOT NULL,
  replacementStatus varchar(50) NOT NULL,
  lastUpdatedBy bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_applicantToBeReplacedId (applicantToBeReplacedId),
  KEY fk_applicantToBeSelectedId (applicantToBeSelectedId),
  KEY fk_rp_list_lastupdate (lastUpdatedBy),
  CONSTRAINT fk_applicantToBeReplacedId FOREIGN KEY (applicantToBeReplacedId) REFERENCES application_prog_stage (id),
  CONSTRAINT fk_applicantToBeSelectedId FOREIGN KEY (applicantToBeSelectedId) REFERENCES application_prog_stage (id),
  CONSTRAINT fk_rp_list_lastupdate FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);



