CREATE TABLE `vechicle_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `capacity` int(11) DEFAULT NULL,
  `model` varchar(45) DEFAULT NULL,
  `purchaseFrom` varchar(255) DEFAULT NULL,
  `serviceBy` varchar(255) DEFAULT NULL,
  `vehicleCode` varchar(45) DEFAULT NULL,
  `vehicleNumber` varchar(60) DEFAULT NULL,
  `whetherRouteApplicable` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `purchaseFromAddressId` bigint(20) DEFAULT NULL,
  `serviceByAddressId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `vehicle_emission_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `emissionCheckOn` date DEFAULT NULL,
  `emissionCost` double DEFAULT NULL,
  `emissionPolicyWith` varchar(100) DEFAULT NULL,
  `emissionToBeCheckOn` date DEFAULT NULL,
  `emissionVendor` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `emissionVendorAddressId` bigint(20) DEFAULT NULL,
  `emissionCurrencyId` bigint(20) DEFAULT NULL,
  `vechicleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `vehicle_emission_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `vehicleEmissionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `vehicle_insurance_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `insuranceCost` double DEFAULT NULL,
  `insurancePaidOn` date DEFAULT NULL,
  `insurancePolicyWith` varchar(100) DEFAULT NULL,
  `insuranceVendor` varchar(100) DEFAULT NULL,
  `policyNumber` varchar(255) DEFAULT NULL,
  `validFrom` date DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `insuranceVendorAddressId` bigint(20) DEFAULT NULL,
  `insuranceCurrencyId` bigint(20) DEFAULT NULL,
  `vechicleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `vehicle_insurance_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `vehicleInsuranceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `vehicle_road_tax_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `referenceNumber` varchar(100) DEFAULT NULL,
  `roadTaxCost` double DEFAULT NULL,
  `roadTaxPaidOn` date DEFAULT NULL,
  `roadTaxVendor` varchar(100) DEFAULT NULL,
  `roadTaxWith` varchar(100) DEFAULT NULL,
  `validFrom` date DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roadTaxVendorAddressId` bigint(20) DEFAULT NULL,
  `roadTaxCurrency` bigint(20) DEFAULT NULL,
  `vechicleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `vehicle_road_tax_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `vehicleRoadTaxId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
