CREATE TABLE `trans_service_route_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `routeId` BIGINT(20) NULL DEFAULT NULL,
  `serviceName` VARCHAR(255) NULL DEFAULT NULL,
  `responsiblePersonId` BIGINT(20) NULL DEFAULT NULL,
  `responsiblePersonName` VARCHAR(100) NULL DEFAULT NULL,
  `startLocation` BIGINT(20) NULL DEFAULT NULL,
  `startTime` TIMESTAMP NULL DEFAULT NULL,
  `endLocation` BIGINT(20) NULL DEFAULT NULL,
  `reachTime` TIMESTAMP NULL DEFAULT NULL,
  `distance` DOUBLE(10,2) NULL DEFAULT NULL,
  `whetherActive` BIT(1) NULL DEFAULT NULL,
  `routeBillType` VARCHAR(45) NULL DEFAULT NULL,
  `feePlanId` BIGINT(20) NULL DEFAULT NULL,
  `droolsAgenda` VARCHAR(255) NULL DEFAULT NULL,
  `droolsRuleRemarks` TEXT NULL DEFAULT NULL,
  `timeRecordForStops` BIT(1) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));


CREATE TABLE `trans_service_route_date_exceptions_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `serviceRouteId` BIGINT(20) NULL DEFAULT NULL,
  `exceptionDate` DATE NULL DEFAULT NULL,
  `originalStatus` VARCHAR(45) NULL DEFAULT NULL,
  `revisedStatus` VARCHAR(45) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));


CREATE TABLE `trans_service_route_runondays_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `serviceRouteId` BIGINT(20) NULL DEFAULT NULL,
  `weekDay` VARCHAR(15) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));

CREATE TABLE `trans_service_route_stops_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `serviceRouteId` BIGINT(20) NULL DEFAULT NULL,
  `stopLocationId` BIGINT(20) NULL DEFAULT NULL,
  `distance` DOUBLE(10,2) NULL DEFAULT NULL,
  `sequence` INT(11) NULL DEFAULT NULL,
  `arrivalTime` TIMESTAMP NULL DEFAULT NULL,
  `departureTime` TIMESTAMP NULL DEFAULT NULL,
  `routeStopType` VARCHAR(45) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));


CREATE TABLE `trans_service_route_users_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `serviceRouteId` BIGINT(20) NULL DEFAULT NULL,
  `userId` BIGINT(20) NULL DEFAULT NULL,
  `userName` VARCHAR(255) NULL DEFAULT NULL,
  `dateAdded` DATE NULL DEFAULT NULL,
  `addtionEffectiveFrom` DATE NULL DEFAULT NULL,
  `dateRemoved` DATE NULL DEFAULT NULL,
  `removalEffectiveForm` DATE NULL DEFAULT NULL,
  `usageStatus` VARCHAR(45) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));


CREATE TABLE `trans_service_route_vehicles_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `serviceRouteId` BIGINT(20) NULL DEFAULT NULL,
  `vehicleId` BIGINT(20) NULL DEFAULT NULL,
  `whetherActive` BIT(1) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));
