CREATE TABLE `examination_revaluation_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `maxRevaluationToApply` int(11) DEFAULT NULL,
  `revaluationCode` varchar(255) DEFAULT NULL,
  `revaluationFor` varchar(255) DEFAULT NULL,
  `revaluationName` varchar(255) DEFAULT NULL,
  `validTill` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `examination_revaluation_rules_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `maxRevaluationToApply` int(11) DEFAULT NULL,
  `noOfRevaluers` int(11) DEFAULT NULL,
  `revaluationType` varchar(255) DEFAULT NULL,
  `ruleApplicable` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `examRevaluationId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `exam_revaluation_rule_mapping_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `startDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `examRevalRuleId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `examination_student_revaluation_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `appliedDate` datetime DEFAULT NULL,
  `dateOfRevaluation` datetime DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `previousGrade` varchar(255) DEFAULT NULL,
  `previousGradePoint` double DEFAULT NULL,
  `previousMarks` double DEFAULT NULL,
  `previousResultStatus` varchar(255) DEFAULT NULL,
  `revaluationResultStatus` varchar(255) DEFAULT NULL,
  `revaluationType` varchar(255) DEFAULT NULL,
  `revaluerGrade` varchar(255) DEFAULT NULL,
  `revaluerGradePoint` double DEFAULT NULL,
  `revaluerMarks` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `eventId` bigint(20) DEFAULT NULL,
  `examRevalRuleMappingId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `exam_student_revaluation_fees_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feesCalculationDate` datetime DEFAULT NULL,
  `totalFees` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `examRevalRuleMappingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
