DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291911__AlterReceiptPaymentInstrumentAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291911__AlterReceiptPaymentInstrumentAudit()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='receipt_payment_instrument_history')) THEN
	ALTER TABLE `receipt_payment_instrument_history` 
		ADD COLUMN `acadLocCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `lastUpdate`,
		ADD COLUMN `orgCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConversionId`,
		ADD COLUMN `acadLocCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `orgCurrencyConversionId`,
		ADD COLUMN `orgCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrConvertedAmount`,
		ADD COLUMN `receiptPayInstrumentCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrConvertedAmount`,
		ADD COLUMN `orgCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `receiptPayInstrumentCurrencyId`;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291911__AlterReceiptPaymentInstrumentAudit() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291911__AlterReceiptPaymentInstrumentAudit $$
 
DELIMITER ;