DELIMITER $$
DROP PROCEDURE IF EXISTS V20200512184819__Alter_courseReadingAudit $$
CREATE PROCEDURE V20200512184819__Alter_courseReadingAudit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='course_reading_history' AND column_name in ("status", "dateRequired", "phaseoutYear", "courseReadingPrescribe"))) THEN 
ALTER TABLE `course_reading_history` 
ADD COLUMN `status` BIT(1) NOT NULL DEFAULT b'1' AFTER `topicType`,
ADD COLUMN `dateRequired` DATE NULL AFTER `status`,
ADD COLUMN `phaseoutYear` VARCHAR(45) NULL AFTER `dateRequired`,
ADD COLUMN `courseReadingPrescribe` VARCHAR(45) NULL AFTER `phaseoutYear`;
END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='course_reading_history' AND column_name in ("whetherCompulsory"))) THEN 
ALTER TABLE `course_reading_history` 
CHANGE COLUMN `whetherCompulsory` `whetherCompulsory` BIT(1) NULL DEFAULT NULL ;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='course_reading_variant_history' AND column_name in ("issuedNumber"))) THEN 
ALTER TABLE `course_reading_variant_history` 
ADD COLUMN `issuedNumber` BIGINT(20) NULL AFTER `courseVariantId`;
END IF;

END $$
CALL V20200512184819__Alter_courseReadingAudit() $$
DROP PROCEDURE IF EXISTS V20200512184819__Alter_courseReadingAudit $$
DELIMITER ;