DELIMITER $$

DROP PROCEDURE IF EXISTS V20200817141206__Alter_PersonHistoryAddColumns $$

CREATE PROCEDURE V20200817141206__Alter_PersonHistoryAddColumns()

BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons_history' AND column_name='isMilitarySponsored')) THEN 
  ALTER TABLE `persons_history` 
  ADD COLUMN `isMilitarySponsored` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons_history' AND column_name='isBursaryRequirements')) THEN 
  ALTER TABLE `persons_history` 
  ADD COLUMN `isBursaryRequirements` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons_history' AND column_name='pHDSponsor')) THEN 
  ALTER TABLE `persons_history` 
  ADD COLUMN `pHDSponsor` VARCHAR(100) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons_history' AND column_name='fieldOfInterest')) THEN 
  ALTER TABLE `persons_history` 
  ADD COLUMN `fieldOfInterest` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_person_fieldOfInterest_idx` (`fieldOfInterest` ASC);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons_history' AND column_name='areaOfResearch')) THEN 
  ALTER TABLE `persons_history` 
  ADD COLUMN `areaOfResearch` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_person_areaOfResearch_idx` (`areaOfResearch` ASC);
END IF; 

END $$

CALL V20200817141206__Alter_PersonHistoryAddColumns() $$

DROP PROCEDURE IF EXISTS V20200817141206__Alter_PersonHistoryAddColumns $$

DELIMITER ;