DELIMITER $$
DROP PROCEDURE IF EXISTS V20241206132357__Create_alumniManagementPinkFloydAudit $$
CREATE PROCEDURE V20241206132357__Create_alumniManagementPinkFloydAudit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='alumni_privacy_settings_history')) THEN 
CREATE TABLE alumni_privacy_settings_history (
    id BIGINT NOT NULL,
	REV bigint(20) NOT NULL,
    REVTYPE tinyint(4) NOT NULL,
    alumniUserId BIGINT NOT NULL,
    mobileNumber BOOLEAN NOT NULL DEFAULT TRUE,
    emailId BOOLEAN NOT NULL DEFAULT TRUE,
    gender BOOLEAN NOT NULL DEFAULT TRUE,
    dateOfBirth BOOLEAN NOT NULL DEFAULT TRUE,
    officialEmailId BOOLEAN NOT NULL DEFAULT TRUE,
    officialContactNumber BOOLEAN NOT NULL DEFAULT TRUE,
    lastUpdatedBy bigint DEFAULT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id, REV)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_receipt_generation_queue_history')) THEN
CREATE TABLE alumni_receipt_generation_queue_history (
     id BIGINT NOT NULL,
	REV bigint(20) NOT NULL,
    REVTYPE tinyint(4) NOT NULL,
    completeFilePath VARCHAR(255) NOT NULL UNIQUE,
    receiptPath VARCHAR(255) NOT NULL UNIQUE,
    alumniPaymentId BIGINT DEFAULT NULL,
    userName VARCHAR(255) NOT NULL,
    emailId VARCHAR(255) NOT NULL,
    mobileNumber VARCHAR(20) DEFAULT NULL,
    receiptNumber VARCHAR(255) NOT NULL,
    donationTitle VARCHAR(255) NOT NULL,
    donationCode VARCHAR(255) NOT NULL,
    currencyCode VARCHAR(10) NOT NULL,
    paymentDate TIMESTAMP NOT NULL,
    paymentAmount DOUBLE NOT NULL,
    academyLocationName VARCHAR(255) NOT NULL,
    logoURL VARCHAR(255) DEFAULT NULL,
    currencySymbol VARCHAR(10) DEFAULT NULL,
    reportTemplateId BIGINT DEFAULT NULL,
    academyLocationId BIGINT NOT NULL,
    alumniPersonId BIGINT NOT NULL,
    addressLine1 VARCHAR(255) DEFAULT NULL,
    addressLine2 VARCHAR(255) DEFAULT NULL,
    cityName VARCHAR(255) DEFAULT NULL,
    countryRegionName VARCHAR(255) DEFAULT NULL,
    countryName VARCHAR(255) DEFAULT NULL,
    postalCode VARCHAR(20) DEFAULT NULL,
    failureReason VARCHAR(255) DEFAULT NULL,
    retryCount INT NOT NULL DEFAULT 0,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id, REV)
);
END IF;

END $$
CALL V20241206132357__Create_alumniManagementPinkFloydAudit () $$ 
DROP PROCEDURE IF EXISTS V20241206132357__Create_alumniManagementPinkFloydAudit $$ 
DELIMITER ;