DELIMITER $$
DROP PROCEDURE IF EXISTS V20251125180131__Create_loan_header_history $$
CREATE PROCEDURE V20251125180131__Create_loan_header_history()
BEGIN

IF NOT EXISTS (
    SELECT * FROM information_schema.TABLES 
    WHERE table_schema = DATABASE() 
      AND table_name = 'loan_header_history'
) THEN
CREATE TABLE `loan_header_history` (
    `id` bigint(20) NOT NULL,
    `REV` int NOT NULL,
    `REVTYPE` tinyint DEFAULT NULL,

    `studentId` bigint(20) DEFAULT NULL,
    `loanStatus` varchar(50) DEFAULT NULL,
    `loanDate` date DEFAULT NULL,
    `loanAmount` decimal(19,2) DEFAULT NULL,
    `billHeaderId` bigint(20) DEFAULT NULL,
    `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
    `interestRate` decimal(19,2) DEFAULT NULL,
    `subsidy` decimal(19,2) DEFAULT NULL,
    `tenure` bigint(20) DEFAULT NULL,
    `documentId` bigint(20) DEFAULT NULL,
    `financialInstitutionId` bigint(20) DEFAULT NULL,
    `documentName` varchar(255) DEFAULT NULL,
    `addedBy` bigint(20) DEFAULT NULL,
    `loanNumber` varchar(255) DEFAULT NULL,
    `loanAccount` varchar(255) DEFAULT NULL,

    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

    PRIMARY KEY (`id`, `REV`)
);
END IF; 

END $$
CALL V20251125180131__Create_loan_header_history () $$ 
DROP PROCEDURE IF EXISTS V20251125180131__Create_loan_header_history $$ 
DELIMITER ;