DROP TABLE IF EXISTS `student_documents`;
CREATE TABLE `student_documents` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`documentId` BIGINT(20) NOT NULL,
	`studentId` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`)
);


DROP TABLE IF EXISTS `faculty_documents`;
CREATE TABLE `faculty_documents` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`documentId` BIGINT(20) NOT NULL,
	`facultyId` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `service_request_documents`;
CREATE TABLE `service_request_documents` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`documentId` BIGINT(20) NOT NULL,
	`serviceRequestId` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`)
);

ALTER TABLE student_documents 
	ADD CONSTRAINT FK_student_documents_extended_documents 
    FOREIGN KEY (documentId)
    REFERENCES extended_documents(documentId);
ALTER TABLE student_documents 
	ADD CONSTRAINT FK_student_documents_students 
    FOREIGN KEY (studentId)
    REFERENCES students(personId);
ALTER TABLE student_documents 
	ADD CONSTRAINT FK_student_documents_users 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id);	

	
ALTER TABLE faculty_documents ADD CONSTRAINT FK_faculties_facultyId 
    FOREIGN KEY (facultyId)
    REFERENCES faculties(personId);
ALTER TABLE faculty_documents ADD CONSTRAINT FK_faculty_documents_extended_documents 
	FOREIGN KEY (documentId) 
	REFERENCES extended_documents (documentId);	
ALTER TABLE faculty_documents 
	ADD CONSTRAINT FK_faculty_documents_users 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id);		

ALTER TABLE service_request_documents ADD CONSTRAINT FK_service_requests_id 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id);
ALTER TABLE service_request_documents ADD CONSTRAINT FK_service_request_documents_documentId 
    FOREIGN KEY (documentId)
    REFERENCES extended_documents(documentId);	
ALTER TABLE service_request_documents 
	ADD CONSTRAINT FK_service_request_documents_users 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id);		